/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.Photo;
import com.mypurecloud.sdk.v2.model.ScimEmail;
import com.mypurecloud.sdk.v2.model.ScimMetadata;
import com.mypurecloud.sdk.v2.model.ScimPhoneNumber;
import com.mypurecloud.sdk.v2.model.ScimV2EnterpriseUser;
import com.mypurecloud.sdk.v2.model.ScimV2GroupReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a SCIM V2 Create User")
public class ScimV2CreateUser
implements Serializable {
    private String displayName = null;
    private List<String> schemas = new ArrayList<String>();
    private Boolean active = null;
    private String userName = null;
    private String password = null;
    private String title = null;
    private List<ScimPhoneNumber> phoneNumbers = new ArrayList<ScimPhoneNumber>();
    private List<ScimEmail> emails = new ArrayList<ScimEmail>();
    private List<Photo> photos = new ArrayList<Photo>();
    private List<ScimV2GroupReference> groups = new ArrayList<ScimV2GroupReference>();
    private ScimMetadata meta = null;
    private ScimV2EnterpriseUser urnietfparamsscimschemasextensionenterprise20User = null;

    public ScimV2CreateUser displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Display Name")
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ScimV2CreateUser schemas(List<String> schemas) {
        this.schemas = schemas;
        return this;
    }

    @ApiModelProperty(example="null", value="schemas supported")
    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public ScimV2CreateUser active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(example="null", value="Active flag")
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public ScimV2CreateUser userName(String userName) {
        this.userName = userName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="User Name (Must be Unique) maps to PureCloud e-mail address")
    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ScimV2CreateUser password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(example="null", value="Password (updateOnly)")
    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ScimV2CreateUser title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="Title")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ScimV2CreateUser phoneNumbers(List<ScimPhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    @ApiModelProperty(example="null", value="Phone numbers")
    @JsonProperty(value="phoneNumbers")
    public List<ScimPhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List<ScimPhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public ScimV2CreateUser emails(List<ScimEmail> emails) {
        this.emails = emails;
        return this;
    }

    @ApiModelProperty(example="null", value="Emails")
    @JsonProperty(value="emails")
    public List<ScimEmail> getEmails() {
        return this.emails;
    }

    public void setEmails(List<ScimEmail> emails) {
        this.emails = emails;
    }

    public ScimV2CreateUser photos(List<Photo> photos) {
        this.photos = photos;
        return this;
    }

    @ApiModelProperty(example="null", value="Photos")
    @JsonProperty(value="photos")
    public List<Photo> getPhotos() {
        return this.photos;
    }

    public void setPhotos(List<Photo> photos) {
        this.photos = photos;
    }

    public ScimV2CreateUser groups(List<ScimV2GroupReference> groups) {
        this.groups = groups;
        return this;
    }

    @ApiModelProperty(example="null", value="Group References")
    @JsonProperty(value="groups")
    public List<ScimV2GroupReference> getGroups() {
        return this.groups;
    }

    public void setGroups(List<ScimV2GroupReference> groups) {
        this.groups = groups;
    }

    public ScimV2CreateUser meta(ScimMetadata meta) {
        this.meta = meta;
        return this;
    }

    @ApiModelProperty(example="null", value="Resource SCIM meta")
    @JsonProperty(value="meta")
    public ScimMetadata getMeta() {
        return this.meta;
    }

    public void setMeta(ScimMetadata meta) {
        this.meta = meta;
    }

    public ScimV2CreateUser urnietfparamsscimschemasextensionenterprise20User(ScimV2EnterpriseUser urnietfparamsscimschemasextensionenterprise20User) {
        this.urnietfparamsscimschemasextensionenterprise20User = urnietfparamsscimschemasextensionenterprise20User;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="urn:ietf:params:scim:schemas:extension:enterprise:2.0:User")
    public ScimV2EnterpriseUser getUrnietfparamsscimschemasextensionenterprise20User() {
        return this.urnietfparamsscimschemasextensionenterprise20User;
    }

    public void setUrnietfparamsscimschemasextensionenterprise20User(ScimV2EnterpriseUser urnietfparamsscimschemasextensionenterprise20User) {
        this.urnietfparamsscimschemasextensionenterprise20User = urnietfparamsscimschemasextensionenterprise20User;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimV2CreateUser scimV2CreateUser = (ScimV2CreateUser)o;
        return Objects.equals(this.displayName, scimV2CreateUser.displayName) && Objects.equals(this.schemas, scimV2CreateUser.schemas) && Objects.equals(this.active, scimV2CreateUser.active) && Objects.equals(this.userName, scimV2CreateUser.userName) && Objects.equals(this.password, scimV2CreateUser.password) && Objects.equals(this.title, scimV2CreateUser.title) && Objects.equals(this.phoneNumbers, scimV2CreateUser.phoneNumbers) && Objects.equals(this.emails, scimV2CreateUser.emails) && Objects.equals(this.photos, scimV2CreateUser.photos) && Objects.equals(this.groups, scimV2CreateUser.groups) && Objects.equals(this.meta, scimV2CreateUser.meta) && Objects.equals(this.urnietfparamsscimschemasextensionenterprise20User, scimV2CreateUser.urnietfparamsscimschemasextensionenterprise20User);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.schemas, this.active, this.userName, this.password, this.title, this.phoneNumbers, this.emails, this.photos, this.groups, this.meta, this.urnietfparamsscimschemasextensionenterprise20User);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimV2CreateUser {\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    phoneNumbers: ").append(this.toIndentedString(this.phoneNumbers)).append("\n");
        sb.append("    emails: ").append(this.toIndentedString(this.emails)).append("\n");
        sb.append("    photos: ").append(this.toIndentedString(this.photos)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    urnietfparamsscimschemasextensionenterprise20User: ").append(this.toIndentedString(this.urnietfparamsscimschemasextensionenterprise20User)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

