/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.AsyncApiCallback;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetLicenseDefinitionRequest;
import com.mypurecloud.sdk.v2.api.request.GetLicenseDefinitionsRequest;
import com.mypurecloud.sdk.v2.api.request.GetLicenseOrganizationRequest;
import com.mypurecloud.sdk.v2.api.request.GetLicenseToggleRequest;
import com.mypurecloud.sdk.v2.api.request.GetLicenseUserRequest;
import com.mypurecloud.sdk.v2.api.request.GetLicenseUsersRequest;
import com.mypurecloud.sdk.v2.api.request.PostLicenseOrganizationRequest;
import com.mypurecloud.sdk.v2.api.request.PostLicenseToggleRequest;
import com.mypurecloud.sdk.v2.api.request.PostLicenseUsersRequest;
import com.mypurecloud.sdk.v2.model.LicenseBatchAssignmentRequest;
import com.mypurecloud.sdk.v2.model.LicenseDefinition;
import com.mypurecloud.sdk.v2.model.LicenseOrgToggle;
import com.mypurecloud.sdk.v2.model.LicenseOrganization;
import com.mypurecloud.sdk.v2.model.LicenseUpdateStatus;
import com.mypurecloud.sdk.v2.model.LicenseUser;
import com.mypurecloud.sdk.v2.model.UserLicensesEntityListing;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class LicenseApiAsync {
    private final ApiClient pcapiClient;

    public LicenseApiAsync() {
        this(Configuration.getDefaultApiClient());
    }

    public LicenseApiAsync(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public Future<LicenseDefinition> getLicenseDefinitionAsync(GetLicenseDefinitionRequest request, final AsyncApiCallback<LicenseDefinition> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<LicenseDefinition>(){}, new AsyncApiCallback<ApiResponse<LicenseDefinition>>(){

                @Override
                public void onCompleted(ApiResponse<LicenseDefinition> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LicenseApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<LicenseDefinition>> getLicenseDefinitionAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<LicenseDefinition>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<LicenseDefinition>(){}, new AsyncApiCallback<ApiResponse<LicenseDefinition>>(){

                @Override
                public void onCompleted(ApiResponse<LicenseDefinition> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<List<LicenseDefinition>> getLicenseDefinitionsAsync(GetLicenseDefinitionsRequest request, final AsyncApiCallback<List<LicenseDefinition>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<List<LicenseDefinition>>(){}, new AsyncApiCallback<ApiResponse<List<LicenseDefinition>>>(){

                @Override
                public void onCompleted(ApiResponse<List<LicenseDefinition>> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LicenseApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<List<LicenseDefinition>>> getLicenseDefinitionsAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<List<LicenseDefinition>>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<List<LicenseDefinition>>(){}, new AsyncApiCallback<ApiResponse<List<LicenseDefinition>>>(){

                @Override
                public void onCompleted(ApiResponse<List<LicenseDefinition>> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<LicenseOrganization> getLicenseOrganizationAsync(GetLicenseOrganizationRequest request, final AsyncApiCallback<LicenseOrganization> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<LicenseOrganization>(){}, new AsyncApiCallback<ApiResponse<LicenseOrganization>>(){

                @Override
                public void onCompleted(ApiResponse<LicenseOrganization> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LicenseApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<LicenseOrganization>> getLicenseOrganizationAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<LicenseOrganization>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<LicenseOrganization>(){}, new AsyncApiCallback<ApiResponse<LicenseOrganization>>(){

                @Override
                public void onCompleted(ApiResponse<LicenseOrganization> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<LicenseOrgToggle> getLicenseToggleAsync(GetLicenseToggleRequest request, final AsyncApiCallback<LicenseOrgToggle> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<LicenseOrgToggle>(){}, new AsyncApiCallback<ApiResponse<LicenseOrgToggle>>(){

                @Override
                public void onCompleted(ApiResponse<LicenseOrgToggle> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LicenseApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<LicenseOrgToggle>> getLicenseToggleAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<LicenseOrgToggle>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<LicenseOrgToggle>(){}, new AsyncApiCallback<ApiResponse<LicenseOrgToggle>>(){

                @Override
                public void onCompleted(ApiResponse<LicenseOrgToggle> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<LicenseUser> getLicenseUserAsync(GetLicenseUserRequest request, final AsyncApiCallback<LicenseUser> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<LicenseUser>(){}, new AsyncApiCallback<ApiResponse<LicenseUser>>(){

                @Override
                public void onCompleted(ApiResponse<LicenseUser> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LicenseApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<LicenseUser>> getLicenseUserAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<LicenseUser>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<LicenseUser>(){}, new AsyncApiCallback<ApiResponse<LicenseUser>>(){

                @Override
                public void onCompleted(ApiResponse<LicenseUser> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<UserLicensesEntityListing> getLicenseUsersAsync(GetLicenseUsersRequest request, final AsyncApiCallback<UserLicensesEntityListing> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<UserLicensesEntityListing>(){}, new AsyncApiCallback<ApiResponse<UserLicensesEntityListing>>(){

                @Override
                public void onCompleted(ApiResponse<UserLicensesEntityListing> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LicenseApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<UserLicensesEntityListing>> getLicenseUsersAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<UserLicensesEntityListing>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<UserLicensesEntityListing>(){}, new AsyncApiCallback<ApiResponse<UserLicensesEntityListing>>(){

                @Override
                public void onCompleted(ApiResponse<UserLicensesEntityListing> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<List<LicenseUpdateStatus>> postLicenseOrganizationAsync(PostLicenseOrganizationRequest request, final AsyncApiCallback<List<LicenseUpdateStatus>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<List<LicenseUpdateStatus>>(){}, new AsyncApiCallback<ApiResponse<List<LicenseUpdateStatus>>>(){

                @Override
                public void onCompleted(ApiResponse<List<LicenseUpdateStatus>> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LicenseApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<List<LicenseUpdateStatus>>> postLicenseOrganizationAsync(ApiRequest<LicenseBatchAssignmentRequest> request, final AsyncApiCallback<ApiResponse<List<LicenseUpdateStatus>>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<List<LicenseUpdateStatus>>(){}, new AsyncApiCallback<ApiResponse<List<LicenseUpdateStatus>>>(){

                @Override
                public void onCompleted(ApiResponse<List<LicenseUpdateStatus>> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<LicenseOrgToggle> postLicenseToggleAsync(PostLicenseToggleRequest request, final AsyncApiCallback<LicenseOrgToggle> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<LicenseOrgToggle>(){}, new AsyncApiCallback<ApiResponse<LicenseOrgToggle>>(){

                @Override
                public void onCompleted(ApiResponse<LicenseOrgToggle> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LicenseApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<LicenseOrgToggle>> postLicenseToggleAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<LicenseOrgToggle>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<LicenseOrgToggle>(){}, new AsyncApiCallback<ApiResponse<LicenseOrgToggle>>(){

                @Override
                public void onCompleted(ApiResponse<LicenseOrgToggle> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<Map<String, Object>> postLicenseUsersAsync(PostLicenseUsersRequest request, final AsyncApiCallback<Map<String, Object>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<Map<String, Object>>(){}, new AsyncApiCallback<ApiResponse<Map<String, Object>>>(){

                @Override
                public void onCompleted(ApiResponse<Map<String, Object>> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        LicenseApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<Map<String, Object>>> postLicenseUsersAsync(ApiRequest<List<String>> request, final AsyncApiCallback<ApiResponse<Map<String, Object>>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<Map<String, Object>>(){}, new AsyncApiCallback<ApiResponse<Map<String, Object>>>(){

                @Override
                public void onCompleted(ApiResponse<Map<String, Object>> response) {
                    LicenseApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        LicenseApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        LicenseApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    private <T> void notifySuccess(SettableFuture<T> future, AsyncApiCallback<T> callback, T result) {
        if (callback != null) {
            try {
                callback.onCompleted(result);
                future.set(result);
            }
            catch (Throwable exception) {
                future.setException(exception);
            }
        } else {
            future.set(result);
        }
    }

    private <T> void notifyFailure(SettableFuture<T> future, AsyncApiCallback<T> callback, Throwable exception) {
        if (callback != null) {
            try {
                callback.onFailed(exception);
                future.setException(exception);
            }
            catch (Throwable callbackException) {
                future.setException(callbackException);
            }
        } else {
            future.setException(exception);
        }
    }
}

