/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.IVR;
import java.util.HashMap;
import java.util.Map;

public class PutArchitectIvrRequest {
    private String ivrId;
    private IVR body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getIvrId() {
        return this.ivrId;
    }

    public void setIvrId(String ivrId) {
        this.ivrId = ivrId;
    }

    public PutArchitectIvrRequest withIvrId(String ivrId) {
        this.setIvrId(ivrId);
        return this;
    }

    public IVR getBody() {
        return this.body;
    }

    public void setBody(IVR body) {
        this.body = body;
    }

    public PutArchitectIvrRequest withBody(IVR body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutArchitectIvrRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<IVR> withHttpInfo() {
        if (this.ivrId == null) {
            throw new IllegalStateException("Missing the required parameter 'ivrId' when building request for PutArchitectIvrRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutArchitectIvrRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/architect/ivrs/{ivrId}").withPathParameter("ivrId", this.ivrId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String ivrId, IVR body) {
        return new Builder().withRequiredParams(ivrId, body);
    }

    public static class Builder {
        private final PutArchitectIvrRequest request = new PutArchitectIvrRequest();

        private Builder() {
        }

        public Builder withIvrId(String ivrId) {
            this.request.setIvrId(ivrId);
            return this;
        }

        public Builder withBody(IVR body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String ivrId, IVR body) {
            this.request.setIvrId(ivrId);
            this.request.setBody(body);
            return this;
        }

        public PutArchitectIvrRequest build() {
            if (this.request.ivrId == null) {
                throw new IllegalStateException("Missing the required parameter 'ivrId' when building request for PutArchitectIvrRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutArchitectIvrRequest.");
            }
            return this.request;
        }
    }
}

