/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.CallForwarding;
import java.util.HashMap;
import java.util.Map;

public class PatchUserCallforwardingRequest {
    private String userId;
    private CallForwarding body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PatchUserCallforwardingRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public CallForwarding getBody() {
        return this.body;
    }

    public void setBody(CallForwarding body) {
        this.body = body;
    }

    public PatchUserCallforwardingRequest withBody(CallForwarding body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchUserCallforwardingRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<CallForwarding> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PatchUserCallforwardingRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchUserCallforwardingRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/users/{userId}/callforwarding").withPathParameter("userId", this.userId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, CallForwarding body) {
        return new Builder().withRequiredParams(userId, body);
    }

    public static class Builder {
        private final PatchUserCallforwardingRequest request = new PatchUserCallforwardingRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withBody(CallForwarding body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String userId, CallForwarding body) {
            this.request.setUserId(userId);
            this.request.setBody(body);
            return this;
        }

        public PatchUserCallforwardingRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for PatchUserCallforwardingRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchUserCallforwardingRequest.");
            }
            return this.request;
        }
    }
}

