/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class TimeOffRequest
implements Serializable {
    private String id = null;
    private String name = null;
    private User user = null;
    private Boolean isFullDayRequest = null;
    private Boolean markedAsRead = null;
    private String activityCodeId = null;
    private StatusEnum status = null;
    private List<Date> partialDayStartDateTimes = new ArrayList<Date>();
    private Integer dailyDurationMinutes = null;
    private String notes = null;
    private User submittedBy = null;
    private Date submittedDate = null;
    private User reviewedBy = null;
    private Date reviewedDate = null;
    private User modifiedBy = null;
    private Date modifiedDate = null;
    private String selfUri = null;
    private List<String> fullDayManagementUnitDates = new ArrayList<String>();

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public TimeOffRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TimeOffRequest user(User user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user associated with this TimeOffRequest")
    @JsonProperty(value="user")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public TimeOffRequest isFullDayRequest(Boolean isFullDayRequest) {
        this.isFullDayRequest = isFullDayRequest;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether this is a full day request (false means partial day)")
    @JsonProperty(value="isFullDayRequest")
    public Boolean getIsFullDayRequest() {
        return this.isFullDayRequest;
    }

    public void setIsFullDayRequest(Boolean isFullDayRequest) {
        this.isFullDayRequest = isFullDayRequest;
    }

    public TimeOffRequest markedAsRead(Boolean markedAsRead) {
        this.markedAsRead = markedAsRead;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether this request has been marked as read by the agent")
    @JsonProperty(value="markedAsRead")
    public Boolean getMarkedAsRead() {
        return this.markedAsRead;
    }

    public void setMarkedAsRead(Boolean markedAsRead) {
        this.markedAsRead = markedAsRead;
    }

    public TimeOffRequest activityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the activity code associated with this TimeOffRequest")
    @JsonProperty(value="activityCodeId")
    public String getActivityCodeId() {
        return this.activityCodeId;
    }

    public void setActivityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
    }

    public TimeOffRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The administrative status of this TimeOffRequest")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TimeOffRequest partialDayStartDateTimes(List<Date> partialDayStartDateTimes) {
        this.partialDayStartDateTimes = partialDayStartDateTimes;
        return this;
    }

    @ApiModelProperty(example="null", value="The start date-times for partial day requests.  Required if isFullDayRequest == false")
    @JsonProperty(value="partialDayStartDateTimes")
    public List<Date> getPartialDayStartDateTimes() {
        return this.partialDayStartDateTimes;
    }

    public void setPartialDayStartDateTimes(List<Date> partialDayStartDateTimes) {
        this.partialDayStartDateTimes = partialDayStartDateTimes;
    }

    public TimeOffRequest dailyDurationMinutes(Integer dailyDurationMinutes) {
        this.dailyDurationMinutes = dailyDurationMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The daily duration of this TimeOffRequest in minutes")
    @JsonProperty(value="dailyDurationMinutes")
    public Integer getDailyDurationMinutes() {
        return this.dailyDurationMinutes;
    }

    public void setDailyDurationMinutes(Integer dailyDurationMinutes) {
        this.dailyDurationMinutes = dailyDurationMinutes;
    }

    public TimeOffRequest notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(example="null", value="The notes as input by the one who entered the TimeOffRequest")
    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public TimeOffRequest submittedBy(User submittedBy) {
        this.submittedBy = submittedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who submitted this TimeOffRequest")
    @JsonProperty(value="submittedBy")
    public User getSubmittedBy() {
        return this.submittedBy;
    }

    public void setSubmittedBy(User submittedBy) {
        this.submittedBy = submittedBy;
    }

    @ApiModelProperty(example="null", value="The timestamp when this request was submitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="submittedDate")
    public Date getSubmittedDate() {
        return this.submittedDate;
    }

    public TimeOffRequest reviewedBy(User reviewedBy) {
        this.reviewedBy = reviewedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who reviewed this TimeOffRequest")
    @JsonProperty(value="reviewedBy")
    public User getReviewedBy() {
        return this.reviewedBy;
    }

    public void setReviewedBy(User reviewedBy) {
        this.reviewedBy = reviewedBy;
    }

    @ApiModelProperty(example="null", value="The timestamp when this request was reviewed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="reviewedDate")
    public Date getReviewedDate() {
        return this.reviewedDate;
    }

    public TimeOffRequest modifiedBy(User modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who last modified this TimeOffRequest")
    @JsonProperty(value="modifiedBy")
    public User getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(User modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @ApiModelProperty(example="null", value="The timestamp when this request was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="modifiedDate")
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public TimeOffRequest fullDayManagementUnitDates(List<String> fullDayManagementUnitDates) {
        this.fullDayManagementUnitDates = fullDayManagementUnitDates;
        return this;
    }

    @ApiModelProperty(example="null", value="ISO-8601 date only with no timezones.  Should be interpreted in the Management Unit's configured time zone.  Required if isFullDayRequest == true")
    @JsonProperty(value="fullDayManagementUnitDates")
    public List<String> getFullDayManagementUnitDates() {
        return this.fullDayManagementUnitDates;
    }

    public void setFullDayManagementUnitDates(List<String> fullDayManagementUnitDates) {
        this.fullDayManagementUnitDates = fullDayManagementUnitDates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeOffRequest timeOffRequest = (TimeOffRequest)o;
        return Objects.equals(this.id, timeOffRequest.id) && Objects.equals(this.name, timeOffRequest.name) && Objects.equals(this.user, timeOffRequest.user) && Objects.equals(this.isFullDayRequest, timeOffRequest.isFullDayRequest) && Objects.equals(this.markedAsRead, timeOffRequest.markedAsRead) && Objects.equals(this.activityCodeId, timeOffRequest.activityCodeId) && Objects.equals((Object)this.status, (Object)timeOffRequest.status) && Objects.equals(this.partialDayStartDateTimes, timeOffRequest.partialDayStartDateTimes) && Objects.equals(this.dailyDurationMinutes, timeOffRequest.dailyDurationMinutes) && Objects.equals(this.notes, timeOffRequest.notes) && Objects.equals(this.submittedBy, timeOffRequest.submittedBy) && Objects.equals(this.submittedDate, timeOffRequest.submittedDate) && Objects.equals(this.reviewedBy, timeOffRequest.reviewedBy) && Objects.equals(this.reviewedDate, timeOffRequest.reviewedDate) && Objects.equals(this.modifiedBy, timeOffRequest.modifiedBy) && Objects.equals(this.modifiedDate, timeOffRequest.modifiedDate) && Objects.equals(this.selfUri, timeOffRequest.selfUri) && Objects.equals(this.fullDayManagementUnitDates, timeOffRequest.fullDayManagementUnitDates);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.user, this.isFullDayRequest, this.markedAsRead, this.activityCodeId, this.status, this.partialDayStartDateTimes, this.dailyDurationMinutes, this.notes, this.submittedBy, this.submittedDate, this.reviewedBy, this.reviewedDate, this.modifiedBy, this.modifiedDate, this.selfUri, this.fullDayManagementUnitDates});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeOffRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    isFullDayRequest: ").append(this.toIndentedString(this.isFullDayRequest)).append("\n");
        sb.append("    markedAsRead: ").append(this.toIndentedString(this.markedAsRead)).append("\n");
        sb.append("    activityCodeId: ").append(this.toIndentedString(this.activityCodeId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    partialDayStartDateTimes: ").append(this.toIndentedString(this.partialDayStartDateTimes)).append("\n");
        sb.append("    dailyDurationMinutes: ").append(this.toIndentedString(this.dailyDurationMinutes)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    submittedBy: ").append(this.toIndentedString(this.submittedBy)).append("\n");
        sb.append("    submittedDate: ").append(this.toIndentedString(this.submittedDate)).append("\n");
        sb.append("    reviewedBy: ").append(this.toIndentedString(this.reviewedBy)).append("\n");
        sb.append("    reviewedDate: ").append(this.toIndentedString(this.reviewedDate)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    fullDayManagementUnitDates: ").append(this.toIndentedString(this.fullDayManagementUnitDates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("PENDING"),
        APPROVED("APPROVED"),
        DENIED("DENIED"),
        CANCELED("CANCELED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

