/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetLocationRequest;
import com.mypurecloud.sdk.v2.api.request.GetLocationsRequest;
import com.mypurecloud.sdk.v2.api.request.GetLocationsSearchRequest;
import com.mypurecloud.sdk.v2.api.request.PostLocationsSearchRequest;
import com.mypurecloud.sdk.v2.model.LocationDefinition;
import com.mypurecloud.sdk.v2.model.LocationSearchRequest;
import com.mypurecloud.sdk.v2.model.LocationsSearchResponse;
import java.io.IOException;
import java.util.List;

public class LocationsApi {
    private final ApiClient pcapiClient;

    public LocationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LocationsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public LocationDefinition getLocation(String locationId) throws IOException, ApiException {
        return this.getLocation(this.createGetLocationRequest(locationId));
    }

    public ApiResponse<LocationDefinition> getLocationWithHttpInfo(String locationId) throws IOException {
        return this.getLocation(this.createGetLocationRequest(locationId).withHttpInfo());
    }

    private GetLocationRequest createGetLocationRequest(String locationId) {
        return GetLocationRequest.builder().withLocationId(locationId).build();
    }

    public LocationDefinition getLocation(GetLocationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LocationDefinition> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LocationDefinition>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LocationDefinition> getLocation(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LocationDefinition>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public List<LocationDefinition> getLocations(Integer pageSize, Integer pageNumber, String sortOrder) throws IOException, ApiException {
        return this.getLocations(this.createGetLocationsRequest(pageSize, pageNumber, sortOrder));
    }

    public ApiResponse<List<LocationDefinition>> getLocationsWithHttpInfo(Integer pageSize, Integer pageNumber, String sortOrder) throws IOException {
        return this.getLocations(this.createGetLocationsRequest(pageSize, pageNumber, sortOrder).withHttpInfo());
    }

    private GetLocationsRequest createGetLocationsRequest(Integer pageSize, Integer pageNumber, String sortOrder) {
        return GetLocationsRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withSortOrder(sortOrder).build();
    }

    public List<LocationDefinition> getLocations(GetLocationsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<List<LocationDefinition>> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<List<LocationDefinition>>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<List<LocationDefinition>> getLocations(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<List<LocationDefinition>>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LocationsSearchResponse getLocationsSearch(String q64, List<String> expand) throws IOException, ApiException {
        return this.getLocationsSearch(this.createGetLocationsSearchRequest(q64, expand));
    }

    public ApiResponse<LocationsSearchResponse> getLocationsSearchWithHttpInfo(String q64, List<String> expand) throws IOException {
        return this.getLocationsSearch(this.createGetLocationsSearchRequest(q64, expand).withHttpInfo());
    }

    private GetLocationsSearchRequest createGetLocationsSearchRequest(String q64, List<String> expand) {
        return GetLocationsSearchRequest.builder().withQ64(q64).withExpand(expand).build();
    }

    public LocationsSearchResponse getLocationsSearch(GetLocationsSearchRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LocationsSearchResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LocationsSearchResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LocationsSearchResponse> getLocationsSearch(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LocationsSearchResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LocationsSearchResponse postLocationsSearch(LocationSearchRequest body) throws IOException, ApiException {
        return this.postLocationsSearch(this.createPostLocationsSearchRequest(body));
    }

    public ApiResponse<LocationsSearchResponse> postLocationsSearchWithHttpInfo(LocationSearchRequest body) throws IOException {
        return this.postLocationsSearch(this.createPostLocationsSearchRequest(body).withHttpInfo());
    }

    private PostLocationsSearchRequest createPostLocationsSearchRequest(LocationSearchRequest body) {
        return PostLocationsSearchRequest.builder().withBody(body).build();
    }

    public LocationsSearchResponse postLocationsSearch(PostLocationsSearchRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LocationsSearchResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LocationsSearchResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LocationsSearchResponse> postLocationsSearch(ApiRequest<LocationSearchRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LocationsSearchResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

