/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteWebchatDeploymentRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteWebchatSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.GetWebchatDeploymentRequest;
import com.mypurecloud.sdk.v2.api.request.GetWebchatDeploymentsRequest;
import com.mypurecloud.sdk.v2.api.request.GetWebchatSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.PostWebchatDeploymentsRequest;
import com.mypurecloud.sdk.v2.api.request.PutWebchatDeploymentRequest;
import com.mypurecloud.sdk.v2.api.request.PutWebchatSettingsRequest;
import com.mypurecloud.sdk.v2.model.WebChatDeployment;
import com.mypurecloud.sdk.v2.model.WebChatDeploymentEntityListing;
import com.mypurecloud.sdk.v2.model.WebChatSettings;
import java.io.IOException;

public class WebChatApi {
    private final ApiClient pcapiClient;

    public WebChatApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WebChatApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteWebchatDeployment(String deploymentId) throws IOException, ApiException {
        this.deleteWebchatDeployment(this.createDeleteWebchatDeploymentRequest(deploymentId));
    }

    public ApiResponse<Void> deleteWebchatDeploymentWithHttpInfo(String deploymentId) throws IOException {
        return this.deleteWebchatDeployment(this.createDeleteWebchatDeploymentRequest(deploymentId).withHttpInfo());
    }

    private DeleteWebchatDeploymentRequest createDeleteWebchatDeploymentRequest(String deploymentId) {
        return DeleteWebchatDeploymentRequest.builder().withDeploymentId(deploymentId).build();
    }

    public void deleteWebchatDeployment(DeleteWebchatDeploymentRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteWebchatDeployment(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteWebchatSettings() throws IOException, ApiException {
        this.deleteWebchatSettings(this.createDeleteWebchatSettingsRequest());
    }

    public ApiResponse<Void> deleteWebchatSettingsWithHttpInfo() throws IOException {
        return this.deleteWebchatSettings(this.createDeleteWebchatSettingsRequest().withHttpInfo());
    }

    private DeleteWebchatSettingsRequest createDeleteWebchatSettingsRequest() {
        return DeleteWebchatSettingsRequest.builder().build();
    }

    public void deleteWebchatSettings(DeleteWebchatSettingsRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteWebchatSettings(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatDeployment getWebchatDeployment(String deploymentId) throws IOException, ApiException {
        return this.getWebchatDeployment(this.createGetWebchatDeploymentRequest(deploymentId));
    }

    public ApiResponse<WebChatDeployment> getWebchatDeploymentWithHttpInfo(String deploymentId) throws IOException {
        return this.getWebchatDeployment(this.createGetWebchatDeploymentRequest(deploymentId).withHttpInfo());
    }

    private GetWebchatDeploymentRequest createGetWebchatDeploymentRequest(String deploymentId) {
        return GetWebchatDeploymentRequest.builder().withDeploymentId(deploymentId).build();
    }

    public WebChatDeployment getWebchatDeployment(GetWebchatDeploymentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatDeployment> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatDeployment>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatDeployment> getWebchatDeployment(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatDeployment>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatDeploymentEntityListing getWebchatDeployments() throws IOException, ApiException {
        return this.getWebchatDeployments(this.createGetWebchatDeploymentsRequest());
    }

    public ApiResponse<WebChatDeploymentEntityListing> getWebchatDeploymentsWithHttpInfo() throws IOException {
        return this.getWebchatDeployments(this.createGetWebchatDeploymentsRequest().withHttpInfo());
    }

    private GetWebchatDeploymentsRequest createGetWebchatDeploymentsRequest() {
        return GetWebchatDeploymentsRequest.builder().build();
    }

    public WebChatDeploymentEntityListing getWebchatDeployments(GetWebchatDeploymentsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatDeploymentEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatDeploymentEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatDeploymentEntityListing> getWebchatDeployments(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatDeploymentEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatSettings getWebchatSettings() throws IOException, ApiException {
        return this.getWebchatSettings(this.createGetWebchatSettingsRequest());
    }

    public ApiResponse<WebChatSettings> getWebchatSettingsWithHttpInfo() throws IOException {
        return this.getWebchatSettings(this.createGetWebchatSettingsRequest().withHttpInfo());
    }

    private GetWebchatSettingsRequest createGetWebchatSettingsRequest() {
        return GetWebchatSettingsRequest.builder().build();
    }

    public WebChatSettings getWebchatSettings(GetWebchatSettingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatSettings> getWebchatSettings(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatDeployment postWebchatDeployments(WebChatDeployment body) throws IOException, ApiException {
        return this.postWebchatDeployments(this.createPostWebchatDeploymentsRequest(body));
    }

    public ApiResponse<WebChatDeployment> postWebchatDeploymentsWithHttpInfo(WebChatDeployment body) throws IOException {
        return this.postWebchatDeployments(this.createPostWebchatDeploymentsRequest(body).withHttpInfo());
    }

    private PostWebchatDeploymentsRequest createPostWebchatDeploymentsRequest(WebChatDeployment body) {
        return PostWebchatDeploymentsRequest.builder().withBody(body).build();
    }

    public WebChatDeployment postWebchatDeployments(PostWebchatDeploymentsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatDeployment> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatDeployment>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatDeployment> postWebchatDeployments(ApiRequest<WebChatDeployment> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatDeployment>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatDeployment putWebchatDeployment(String deploymentId, WebChatDeployment body) throws IOException, ApiException {
        return this.putWebchatDeployment(this.createPutWebchatDeploymentRequest(deploymentId, body));
    }

    public ApiResponse<WebChatDeployment> putWebchatDeploymentWithHttpInfo(String deploymentId, WebChatDeployment body) throws IOException {
        return this.putWebchatDeployment(this.createPutWebchatDeploymentRequest(deploymentId, body).withHttpInfo());
    }

    private PutWebchatDeploymentRequest createPutWebchatDeploymentRequest(String deploymentId, WebChatDeployment body) {
        return PutWebchatDeploymentRequest.builder().withDeploymentId(deploymentId).withBody(body).build();
    }

    public WebChatDeployment putWebchatDeployment(PutWebchatDeploymentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatDeployment> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatDeployment>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatDeployment> putWebchatDeployment(ApiRequest<WebChatDeployment> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatDeployment>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatSettings putWebchatSettings(WebChatSettings body) throws IOException, ApiException {
        return this.putWebchatSettings(this.createPutWebchatSettingsRequest(body));
    }

    public ApiResponse<WebChatSettings> putWebchatSettingsWithHttpInfo(WebChatSettings body) throws IOException {
        return this.putWebchatSettings(this.createPutWebchatSettingsRequest(body).withHttpInfo());
    }

    private PutWebchatSettingsRequest createPutWebchatSettingsRequest(WebChatSettings body) {
        return PutWebchatSettingsRequest.builder().withBody(body).build();
    }

    public WebChatSettings putWebchatSettings(PutWebchatSettingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatSettings> putWebchatSettings(ApiRequest<WebChatSettings> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

