/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.JsonSchemaDocument;
import java.util.HashMap;
import java.util.Map;

public class PutFlowsDatatableRequest {
    private String datatableId;
    private Boolean showbrief;
    private JsonSchemaDocument body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDatatableId() {
        return this.datatableId;
    }

    public void setDatatableId(String datatableId) {
        this.datatableId = datatableId;
    }

    public PutFlowsDatatableRequest withDatatableId(String datatableId) {
        this.setDatatableId(datatableId);
        return this;
    }

    public Boolean getShowbrief() {
        return this.showbrief;
    }

    public void setShowbrief(Boolean showbrief) {
        this.showbrief = showbrief;
    }

    public PutFlowsDatatableRequest withShowbrief(Boolean showbrief) {
        this.setShowbrief(showbrief);
        return this;
    }

    public JsonSchemaDocument getBody() {
        return this.body;
    }

    public void setBody(JsonSchemaDocument body) {
        this.body = body;
    }

    public PutFlowsDatatableRequest withBody(JsonSchemaDocument body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutFlowsDatatableRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<JsonSchemaDocument> withHttpInfo() {
        if (this.datatableId == null) {
            throw new IllegalStateException("Missing the required parameter 'datatableId' when building request for PutFlowsDatatableRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/flows/datatables/{datatableId}").withPathParameter("datatableId", this.datatableId).withQueryParameters("showbrief", "", this.showbrief).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String datatableId) {
        return new Builder().withRequiredParams(datatableId);
    }

    public static class Builder {
        private final PutFlowsDatatableRequest request = new PutFlowsDatatableRequest();

        private Builder() {
        }

        public Builder withDatatableId(String datatableId) {
            this.request.setDatatableId(datatableId);
            return this;
        }

        public Builder withShowbrief(Boolean showbrief) {
            this.request.setShowbrief(showbrief);
            return this;
        }

        public Builder withBody(JsonSchemaDocument body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String datatableId) {
            this.request.setDatatableId(datatableId);
            return this;
        }

        public PutFlowsDatatableRequest build() {
            if (this.request.datatableId == null) {
                throw new IllegalStateException("Missing the required parameter 'datatableId' when building request for PutFlowsDatatableRequest.");
            }
            return this.request;
        }
    }
}

