/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetConversationsEmailMessageRequest {
    private String emailId;
    private String messageId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getEmailId() {
        return this.emailId;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public GetConversationsEmailMessageRequest withEmailId(String emailId) {
        this.setEmailId(emailId);
        return this;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public GetConversationsEmailMessageRequest withMessageId(String messageId) {
        this.setMessageId(messageId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetConversationsEmailMessageRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.emailId == null) {
            throw new IllegalStateException("Missing the required parameter 'emailId' when building request for GetConversationsEmailMessageRequest.");
        }
        if (this.messageId == null) {
            throw new IllegalStateException("Missing the required parameter 'messageId' when building request for GetConversationsEmailMessageRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/conversations/emails/{emailId}/messages/{messageId}").withPathParameter("emailId", this.emailId).withPathParameter("messageId", this.messageId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String emailId, String messageId) {
        return new Builder().withRequiredParams(emailId, messageId);
    }

    public static class Builder {
        private final GetConversationsEmailMessageRequest request = new GetConversationsEmailMessageRequest();

        private Builder() {
        }

        public Builder withEmailId(String emailId) {
            this.request.setEmailId(emailId);
            return this;
        }

        public Builder withMessageId(String messageId) {
            this.request.setMessageId(messageId);
            return this;
        }

        public Builder withRequiredParams(String emailId, String messageId) {
            this.request.setEmailId(emailId);
            this.request.setMessageId(messageId);
            return this;
        }

        public GetConversationsEmailMessageRequest build() {
            if (this.request.emailId == null) {
                throw new IllegalStateException("Missing the required parameter 'emailId' when building request for GetConversationsEmailMessageRequest.");
            }
            if (this.request.messageId == null) {
                throw new IllegalStateException("Missing the required parameter 'messageId' when building request for GetConversationsEmailMessageRequest.");
            }
            return this.request;
        }
    }
}

