/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutConversationRecordingAnnotationRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String conversationId;
    private String recordingId;
    private String annotationId;
    private Annotation body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PutConversationRecordingAnnotationRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getRecordingId() {
        return this.recordingId;
    }

    public void setRecordingId(String recordingId) {
        this.recordingId = recordingId;
    }

    public PutConversationRecordingAnnotationRequest withRecordingId(String recordingId) {
        this.setRecordingId(recordingId);
        return this;
    }

    public String getAnnotationId() {
        return this.annotationId;
    }

    public void setAnnotationId(String annotationId) {
        this.annotationId = annotationId;
    }

    public PutConversationRecordingAnnotationRequest withAnnotationId(String annotationId) {
        this.setAnnotationId(annotationId);
        return this;
    }

    public Annotation getBody() {
        return this.body;
    }

    public void setBody(Annotation body) {
        this.body = body;
    }

    public PutConversationRecordingAnnotationRequest withBody(Annotation body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutConversationRecordingAnnotationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Annotation> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PutConversationRecordingAnnotationRequest.");
        }
        if (this.recordingId == null) {
            throw new IllegalStateException("Missing the required parameter 'recordingId' when building request for PutConversationRecordingAnnotationRequest.");
        }
        if (this.annotationId == null) {
            throw new IllegalStateException("Missing the required parameter 'annotationId' when building request for PutConversationRecordingAnnotationRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutConversationRecordingAnnotationRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId}").withPathParameter("conversationId", this.conversationId).withPathParameter("recordingId", this.recordingId).withPathParameter("annotationId", this.annotationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String recordingId, String annotationId, Annotation body) {
        return new Builder().withRequiredParams(conversationId, recordingId, annotationId, body);
    }

    public static class Builder {
        private final PutConversationRecordingAnnotationRequest request = new PutConversationRecordingAnnotationRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withRecordingId(String recordingId) {
            this.request.setRecordingId(recordingId);
            return this;
        }

        public Builder withAnnotationId(String annotationId) {
            this.request.setAnnotationId(annotationId);
            return this;
        }

        public Builder withBody(Annotation body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String recordingId, String annotationId, Annotation body) {
            this.request.setConversationId(conversationId);
            this.request.setRecordingId(recordingId);
            this.request.setAnnotationId(annotationId);
            this.request.setBody(body);
            return this;
        }

        public PutConversationRecordingAnnotationRequest build() {
            return this.request;
        }
    }
}

