/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetGreetingRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String greetingId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGreetingId() {
        return this.greetingId;
    }

    public void setGreetingId(String greetingId) {
        this.greetingId = greetingId;
    }

    public GetGreetingRequest withGreetingId(String greetingId) {
        this.setGreetingId(greetingId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetGreetingRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.greetingId == null) {
            throw new IllegalStateException("Missing the required parameter 'greetingId' when building request for GetGreetingRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/greetings/{greetingId}").withPathParameter("greetingId", this.greetingId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String greetingId) {
        return new Builder().withRequiredParams(greetingId);
    }

    public static class Builder {
        private final GetGreetingRequest request = new GetGreetingRequest();

        private Builder() {
        }

        public Builder withGreetingId(String greetingId) {
            this.request.setGreetingId(greetingId);
            return this;
        }

        public Builder withRequiredParams(String greetingId) {
            this.request.setGreetingId(greetingId);
            return this;
        }

        public GetGreetingRequest build() {
            return this.request;
        }
    }
}

