/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.SequenceSchedule;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutOutboundSchedulesSequenceRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String sequenceId;
    private SequenceSchedule body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(String sequenceId) {
        this.sequenceId = sequenceId;
    }

    public PutOutboundSchedulesSequenceRequest withSequenceId(String sequenceId) {
        this.setSequenceId(sequenceId);
        return this;
    }

    public SequenceSchedule getBody() {
        return this.body;
    }

    public void setBody(SequenceSchedule body) {
        this.body = body;
    }

    public PutOutboundSchedulesSequenceRequest withBody(SequenceSchedule body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutOutboundSchedulesSequenceRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<SequenceSchedule> withHttpInfo() {
        if (this.sequenceId == null) {
            throw new IllegalStateException("Missing the required parameter 'sequenceId' when building request for PutOutboundSchedulesSequenceRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutOutboundSchedulesSequenceRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/outbound/schedules/sequences/{sequenceId}").withPathParameter("sequenceId", this.sequenceId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String sequenceId, SequenceSchedule body) {
        return new Builder().withRequiredParams(sequenceId, body);
    }

    public static class Builder {
        private final PutOutboundSchedulesSequenceRequest request = new PutOutboundSchedulesSequenceRequest();

        private Builder() {
        }

        public Builder withSequenceId(String sequenceId) {
            this.request.setSequenceId(sequenceId);
            return this;
        }

        public Builder withBody(SequenceSchedule body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String sequenceId, SequenceSchedule body) {
            this.request.setSequenceId(sequenceId);
            this.request.setBody(body);
            return this;
        }

        public PutOutboundSchedulesSequenceRequest build() {
            return this.request;
        }
    }
}

