/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.PromptAssetCreate;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PostArchitectPromptResourcesRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String promptId;
    private PromptAssetCreate body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getPromptId() {
        return this.promptId;
    }

    public void setPromptId(String promptId) {
        this.promptId = promptId;
    }

    public PostArchitectPromptResourcesRequest withPromptId(String promptId) {
        this.setPromptId(promptId);
        return this;
    }

    public PromptAssetCreate getBody() {
        return this.body;
    }

    public void setBody(PromptAssetCreate body) {
        this.body = body;
    }

    public PostArchitectPromptResourcesRequest withBody(PromptAssetCreate body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostArchitectPromptResourcesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<PromptAssetCreate> withHttpInfo() {
        if (this.promptId == null) {
            throw new IllegalStateException("Missing the required parameter 'promptId' when building request for PostArchitectPromptResourcesRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/architect/prompts/{promptId}/resources").withPathParameter("promptId", this.promptId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String promptId) {
        return new Builder().withRequiredParams(promptId);
    }

    public static class Builder {
        private final PostArchitectPromptResourcesRequest request = new PostArchitectPromptResourcesRequest();

        private Builder() {
        }

        public Builder withPromptId(String promptId) {
            this.request.setPromptId(promptId);
            return this;
        }

        public Builder withBody(PromptAssetCreate body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String promptId) {
            this.request.setPromptId(promptId);
            return this;
        }

        public PostArchitectPromptResourcesRequest build() {
            return this.request;
        }
    }
}

