/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.DocumentUpdate;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PostContentmanagementDocumentRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String documentId;
    private DocumentUpdate body;
    private String expand;
    private Boolean override;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public PostContentmanagementDocumentRequest withDocumentId(String documentId) {
        this.setDocumentId(documentId);
        return this;
    }

    public DocumentUpdate getBody() {
        return this.body;
    }

    public void setBody(DocumentUpdate body) {
        this.body = body;
    }

    public PostContentmanagementDocumentRequest withBody(DocumentUpdate body) {
        this.setBody(body);
        return this;
    }

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public PostContentmanagementDocumentRequest withExpand(String expand) {
        this.setExpand(expand);
        return this;
    }

    public Boolean getOverride() {
        return this.override;
    }

    public void setOverride(Boolean override) {
        this.override = override;
    }

    public PostContentmanagementDocumentRequest withOverride(Boolean override) {
        this.setOverride(override);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostContentmanagementDocumentRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<DocumentUpdate> withHttpInfo() {
        if (this.documentId == null) {
            throw new IllegalStateException("Missing the required parameter 'documentId' when building request for PostContentmanagementDocumentRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostContentmanagementDocumentRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/contentmanagement/documents/{documentId}").withPathParameter("documentId", this.documentId).withQueryParameters("expand", "", this.expand).withQueryParameters("override", "", this.override).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String documentId, DocumentUpdate body) {
        return new Builder().withRequiredParams(documentId, body);
    }

    public static class Builder {
        private final PostContentmanagementDocumentRequest request = new PostContentmanagementDocumentRequest();

        private Builder() {
        }

        public Builder withDocumentId(String documentId) {
            this.request.setDocumentId(documentId);
            return this;
        }

        public Builder withBody(DocumentUpdate body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withExpand(String expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withOverride(Boolean override) {
            this.request.setOverride(override);
            return this;
        }

        public Builder withRequiredParams(String documentId, DocumentUpdate body) {
            this.request.setDocumentId(documentId);
            this.request.setBody(body);
            return this;
        }

        public PostContentmanagementDocumentRequest build() {
            return this.request;
        }
    }
}

