/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetScriptsPublishedScriptIdPageRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String scriptId;
    private String pageId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public GetScriptsPublishedScriptIdPageRequest withScriptId(String scriptId) {
        this.setScriptId(scriptId);
        return this;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public GetScriptsPublishedScriptIdPageRequest withPageId(String pageId) {
        this.setPageId(pageId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetScriptsPublishedScriptIdPageRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.scriptId == null) {
            throw new IllegalStateException("Missing the required parameter 'scriptId' when building request for GetScriptsPublishedScriptIdPageRequest.");
        }
        if (this.pageId == null) {
            throw new IllegalStateException("Missing the required parameter 'pageId' when building request for GetScriptsPublishedScriptIdPageRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/scripts/published/{scriptId}/pages/{pageId}").withPathParameter("scriptId", this.scriptId).withPathParameter("pageId", this.pageId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String scriptId, String pageId) {
        return new Builder().withRequiredParams(scriptId, pageId);
    }

    public static class Builder {
        private final GetScriptsPublishedScriptIdPageRequest request = new GetScriptsPublishedScriptIdPageRequest();

        private Builder() {
        }

        public Builder withScriptId(String scriptId) {
            this.request.setScriptId(scriptId);
            return this;
        }

        public Builder withPageId(String pageId) {
            this.request.setPageId(pageId);
            return this;
        }

        public Builder withRequiredParams(String scriptId, String pageId) {
            this.request.setScriptId(scriptId);
            this.request.setPageId(pageId);
            return this;
        }

        public GetScriptsPublishedScriptIdPageRequest build() {
            return this.request;
        }
    }
}

