/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.api.request.GetDateRequest;
import com.mypurecloud.sdk.v2.api.request.GetTimezonesRequest;
import com.mypurecloud.sdk.v2.api.request.PostCertificateDetailsRequest;
import com.mypurecloud.sdk.v2.model.Certificate;
import com.mypurecloud.sdk.v2.model.ParsedCertificate;
import com.mypurecloud.sdk.v2.model.ServerDate;
import com.mypurecloud.sdk.v2.model.TimeZoneEntityListing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class UtilitiesApi {
    private final ApiClient pcapiClient;

    public UtilitiesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UtilitiesApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public ServerDate getDate() throws IOException, ApiException {
        return this.getDateWithHttpInfo().getBody();
    }

    public ApiResponse<ServerDate> getDateWithHttpInfo() throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/date".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<ServerDate>(){});
    }

    public ServerDate getDate(GetDateRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<ServerDate>(){});
    }

    public ApiResponse<ServerDate> getDate(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<ServerDate>(){});
    }

    public TimeZoneEntityListing getTimezones(Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        return this.getTimezonesWithHttpInfo(pageSize, pageNumber).getBody();
    }

    public ApiResponse<TimeZoneEntityListing> getTimezonesWithHttpInfo(Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/timezones".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<TimeZoneEntityListing>(){});
    }

    public TimeZoneEntityListing getTimezones(GetTimezonesRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<TimeZoneEntityListing>(){});
    }

    public ApiResponse<TimeZoneEntityListing> getTimezones(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<TimeZoneEntityListing>(){});
    }

    public ParsedCertificate postCertificateDetails(Certificate body) throws IOException, ApiException {
        return this.postCertificateDetailsWithHttpInfo(body).getBody();
    }

    public ApiResponse<ParsedCertificate> postCertificateDetailsWithHttpInfo(Certificate body) throws IOException, ApiException {
        Certificate pclocalVarPostBody = body;
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling postCertificateDetails");
        }
        String pclocalVarPath = "/api/v2/certificate/details".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<ParsedCertificate>(){});
    }

    public ParsedCertificate postCertificateDetails(PostCertificateDetailsRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<ParsedCertificate>(){});
    }

    public ApiResponse<ParsedCertificate> postCertificateDetails(ApiRequest<Certificate> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<ParsedCertificate>(){});
    }
}

