/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WorkitemStatusUpdate
implements Serializable {
    private String name = null;
    private List<String> destinationStatusIds = null;
    private String description = null;
    private String defaultDestinationStatusId = null;
    private Integer statusTransitionDelaySeconds = null;
    private String statusTransitionTime = null;
    private Boolean autoTerminateWorkitem = null;

    public WorkitemStatusUpdate() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.destinationStatusIds = new ArrayList<String>();
        }
    }

    public WorkitemStatusUpdate name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the Status. Valid length between 3 and 256 characters.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkitemStatusUpdate destinationStatusIds(List<String> destinationStatusIds) {
        this.destinationStatusIds = destinationStatusIds;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of destination Statuses where a Workitem with this Status can transition to. If the list is empty Workitems with this Status can transition to all other Statuses defined on the Worktype. A Status can have a maximum of 24 destinations.")
    @JsonProperty(value="destinationStatusIds")
    public List<String> getDestinationStatusIds() {
        return this.destinationStatusIds;
    }

    public void setDestinationStatusIds(List<String> destinationStatusIds) {
        this.destinationStatusIds = destinationStatusIds;
    }

    public WorkitemStatusUpdate description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the Status. Maximum length of 512 characters.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkitemStatusUpdate defaultDestinationStatusId(String defaultDestinationStatusId) {
        this.defaultDestinationStatusId = defaultDestinationStatusId;
        return this;
    }

    @ApiModelProperty(example="null", value="Default destination status to which this Status will transition to if auto status transition enabled.")
    @JsonProperty(value="defaultDestinationStatusId")
    public String getDefaultDestinationStatusId() {
        return this.defaultDestinationStatusId;
    }

    public void setDefaultDestinationStatusId(String defaultDestinationStatusId) {
        this.defaultDestinationStatusId = defaultDestinationStatusId;
    }

    public WorkitemStatusUpdate statusTransitionDelaySeconds(Integer statusTransitionDelaySeconds) {
        this.statusTransitionDelaySeconds = statusTransitionDelaySeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Delay in seconds for auto status transition. Required if defaultDestinationStatusId is provided.")
    @JsonProperty(value="statusTransitionDelaySeconds")
    public Integer getStatusTransitionDelaySeconds() {
        return this.statusTransitionDelaySeconds;
    }

    public void setStatusTransitionDelaySeconds(Integer statusTransitionDelaySeconds) {
        this.statusTransitionDelaySeconds = statusTransitionDelaySeconds;
    }

    public WorkitemStatusUpdate statusTransitionTime(String statusTransitionTime) {
        this.statusTransitionTime = statusTransitionTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Time is represented as an ISO-8601 string without a timezone. For example: HH:mm:ss.SSS")
    @JsonProperty(value="statusTransitionTime")
    public String getStatusTransitionTime() {
        return this.statusTransitionTime;
    }

    public void setStatusTransitionTime(String statusTransitionTime) {
        this.statusTransitionTime = statusTransitionTime;
    }

    public WorkitemStatusUpdate autoTerminateWorkitem(Boolean autoTerminateWorkitem) {
        this.autoTerminateWorkitem = autoTerminateWorkitem;
        return this;
    }

    @ApiModelProperty(example="null", value="Terminate workitem on selection of status. Applicable only for statuses in the Closed category.")
    @JsonProperty(value="autoTerminateWorkitem")
    public Boolean getAutoTerminateWorkitem() {
        return this.autoTerminateWorkitem;
    }

    public void setAutoTerminateWorkitem(Boolean autoTerminateWorkitem) {
        this.autoTerminateWorkitem = autoTerminateWorkitem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkitemStatusUpdate workitemStatusUpdate = (WorkitemStatusUpdate)o;
        return Objects.equals(this.name, workitemStatusUpdate.name) && Objects.equals(this.destinationStatusIds, workitemStatusUpdate.destinationStatusIds) && Objects.equals(this.description, workitemStatusUpdate.description) && Objects.equals(this.defaultDestinationStatusId, workitemStatusUpdate.defaultDestinationStatusId) && Objects.equals(this.statusTransitionDelaySeconds, workitemStatusUpdate.statusTransitionDelaySeconds) && Objects.equals(this.statusTransitionTime, workitemStatusUpdate.statusTransitionTime) && Objects.equals(this.autoTerminateWorkitem, workitemStatusUpdate.autoTerminateWorkitem);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.destinationStatusIds, this.description, this.defaultDestinationStatusId, this.statusTransitionDelaySeconds, this.statusTransitionTime, this.autoTerminateWorkitem);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkitemStatusUpdate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    destinationStatusIds: ").append(this.toIndentedString(this.destinationStatusIds)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    defaultDestinationStatusId: ").append(this.toIndentedString(this.defaultDestinationStatusId)).append("\n");
        sb.append("    statusTransitionDelaySeconds: ").append(this.toIndentedString(this.statusTransitionDelaySeconds)).append("\n");
        sb.append("    statusTransitionTime: ").append(this.toIndentedString(this.statusTransitionTime)).append("\n");
        sb.append("    autoTerminateWorkitem: ").append(this.toIndentedString(this.autoTerminateWorkitem)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

