/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.UserReference;
import com.mypurecloud.sdk.v2.model.UsersRulesCriteria;
import com.mypurecloud.sdk.v2.model.UsersRulesLastRunMetadata;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Users rule response")
public class UsersRulesRule
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private TypeEnum type = null;
    private List<UsersRulesCriteria> criteria = null;
    private Date createdDate = null;
    private UserReference createdBy = null;
    private Date modifiedDate = null;
    private UserReference modifiedBy = null;
    private UsersRulesLastRunMetadata lastRun = null;
    private Long recentRunCount = null;
    private Long dependentCount = null;
    private String selfUri = null;

    public UsersRulesRule() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.criteria = new ArrayList<UsersRulesCriteria>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public UsersRulesRule name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="The description of the rule")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(example="null", value="The type of the rule")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    @ApiModelProperty(example="null", value="The criteria of the rule")
    @JsonProperty(value="criteria")
    public List<UsersRulesCriteria> getCriteria() {
        return this.criteria;
    }

    @ApiModelProperty(example="null", value="The date/time the rule was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @ApiModelProperty(example="null", value="The user who created the rule")
    @JsonProperty(value="createdBy")
    public UserReference getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(example="null", value="The date/time the rule was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="modifiedDate")
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    @ApiModelProperty(example="null", value="The last user to modify the rule")
    @JsonProperty(value="modifiedBy")
    public UserReference getModifiedBy() {
        return this.modifiedBy;
    }

    @ApiModelProperty(example="null", value="Information on the last run of the rule")
    @JsonProperty(value="lastRun")
    public UsersRulesLastRunMetadata getLastRun() {
        return this.lastRun;
    }

    @ApiModelProperty(example="null", value="The number of times the rule has run")
    @JsonProperty(value="recentRunCount")
    public Long getRecentRunCount() {
        return this.recentRunCount;
    }

    @ApiModelProperty(example="null", value="The number of dependents this rule has")
    @JsonProperty(value="dependentCount")
    public Long getDependentCount() {
        return this.dependentCount;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsersRulesRule usersRulesRule = (UsersRulesRule)o;
        return Objects.equals(this.id, usersRulesRule.id) && Objects.equals(this.name, usersRulesRule.name) && Objects.equals(this.description, usersRulesRule.description) && Objects.equals((Object)this.type, (Object)usersRulesRule.type) && Objects.equals(this.criteria, usersRulesRule.criteria) && Objects.equals(this.createdDate, usersRulesRule.createdDate) && Objects.equals(this.createdBy, usersRulesRule.createdBy) && Objects.equals(this.modifiedDate, usersRulesRule.modifiedDate) && Objects.equals(this.modifiedBy, usersRulesRule.modifiedBy) && Objects.equals(this.lastRun, usersRulesRule.lastRun) && Objects.equals(this.recentRunCount, usersRulesRule.recentRunCount) && Objects.equals(this.dependentCount, usersRulesRule.dependentCount) && Objects.equals(this.selfUri, usersRulesRule.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.type, this.criteria, this.createdDate, this.createdBy, this.modifiedDate, this.modifiedBy, this.lastRun, this.recentRunCount, this.dependentCount, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsersRulesRule {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    criteria: ").append(this.toIndentedString(this.criteria)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    lastRun: ").append(this.toIndentedString(this.lastRun)).append("\n");
        sb.append("    recentRunCount: ").append(this.toIndentedString(this.recentRunCount)).append("\n");
        sb.append("    dependentCount: ").append(this.toIndentedString(this.dependentCount)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        LEARNING("Learning");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

