/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class KnowledgeBase
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private CoreLanguageEnum coreLanguage = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Integer faqCount = null;
    private Date dateDocumentLastModified = null;
    private Integer articleCount = null;
    private Boolean published = null;
    private String selfUri = null;

    public KnowledgeBase() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public KnowledgeBase name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public KnowledgeBase description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Knowledge base description")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public KnowledgeBase coreLanguage(CoreLanguageEnum coreLanguage) {
        this.coreLanguage = coreLanguage;
        return this;
    }

    @ApiModelProperty(example="en-US", required=true, value="Core language for knowledge base in which initial content must be created, language codes [en-US, en-UK, en-AU, de-DE] are supported currently. However, the new DX knowledge will support all these language codes, along with 'early preview' language codes [ca-ES, tr-TR, sv-SE, fi-FI, nb-NO, da-DK, ja-JP, ar-AE, zh-CN, zh-TW, zh-HK, ko-KR, pl-PL, hi-IN, th-TH, hu-HU, vi-VN, uk-UA] which might have a lower accuracy.")
    @JsonProperty(value="coreLanguage")
    public CoreLanguageEnum getCoreLanguage() {
        return this.coreLanguage;
    }

    public void setCoreLanguage(CoreLanguageEnum coreLanguage) {
        this.coreLanguage = coreLanguage;
    }

    @ApiModelProperty(example="null", value="Knowledge base creation date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Knowledge base last modification date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The count representing the number of documents of type FAQ in the KnowledgeBase")
    @JsonProperty(value="faqCount")
    public Integer getFaqCount() {
        return this.faqCount;
    }

    @ApiModelProperty(example="null", value="The date representing when the last document is modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateDocumentLastModified")
    public Date getDateDocumentLastModified() {
        return this.dateDocumentLastModified;
    }

    @ApiModelProperty(example="null", value="The count representing the number of documents of type Article in the KnowledgeBase")
    @JsonProperty(value="articleCount")
    public Integer getArticleCount() {
        return this.articleCount;
    }

    @ApiModelProperty(example="null", value="Flag that indicates the knowledge base is published")
    @JsonProperty(value="published")
    public Boolean getPublished() {
        return this.published;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeBase knowledgeBase = (KnowledgeBase)o;
        return Objects.equals(this.id, knowledgeBase.id) && Objects.equals(this.name, knowledgeBase.name) && Objects.equals(this.description, knowledgeBase.description) && Objects.equals((Object)this.coreLanguage, (Object)knowledgeBase.coreLanguage) && Objects.equals(this.dateCreated, knowledgeBase.dateCreated) && Objects.equals(this.dateModified, knowledgeBase.dateModified) && Objects.equals(this.faqCount, knowledgeBase.faqCount) && Objects.equals(this.dateDocumentLastModified, knowledgeBase.dateDocumentLastModified) && Objects.equals(this.articleCount, knowledgeBase.articleCount) && Objects.equals(this.published, knowledgeBase.published) && Objects.equals(this.selfUri, knowledgeBase.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.coreLanguage, this.dateCreated, this.dateModified, this.faqCount, this.dateDocumentLastModified, this.articleCount, this.published, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeBase {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    coreLanguage: ").append(this.toIndentedString((Object)this.coreLanguage)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    faqCount: ").append(this.toIndentedString(this.faqCount)).append("\n");
        sb.append("    dateDocumentLastModified: ").append(this.toIndentedString(this.dateDocumentLastModified)).append("\n");
        sb.append("    articleCount: ").append(this.toIndentedString(this.articleCount)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CoreLanguageEnumDeserializer.class)
    public static enum CoreLanguageEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EN_US("en-US"),
        EN_UK("en-UK"),
        EN_AU("en-AU"),
        EN_CA("en-CA"),
        EN_HK("en-HK"),
        EN_IN("en-IN"),
        EN_IE("en-IE"),
        EN_NZ("en-NZ"),
        EN_PH("en-PH"),
        EN_SG("en-SG"),
        EN_ZA("en-ZA"),
        DE_DE("de-DE"),
        DE_AT("de-AT"),
        DE_CH("de-CH"),
        ES_AR("es-AR"),
        ES_CO("es-CO"),
        ES_MX("es-MX"),
        ES_US("es-US"),
        ES_ES("es-ES"),
        FR_FR("fr-FR"),
        FR_BE("fr-BE"),
        FR_CA("fr-CA"),
        FR_CH("fr-CH"),
        PT_BR("pt-BR"),
        PT_PT("pt-PT"),
        NL_NL("nl-NL"),
        NL_BE("nl-BE"),
        IT_IT("it-IT"),
        CA_ES("ca-ES"),
        TR_TR("tr-TR"),
        SV_SE("sv-SE"),
        FI_FI("fi-FI"),
        NB_NO("nb-NO"),
        DA_DK("da-DK"),
        JA_JP("ja-JP"),
        AR_AE("ar-AE"),
        ZH_CN("zh-CN"),
        ZH_TW("zh-TW"),
        ZH_HK("zh-HK"),
        KO_KR("ko-KR"),
        PL_PL("pl-PL"),
        HI_IN("hi-IN"),
        TH_TH("th-TH"),
        HU_HU("hu-HU"),
        VI_VN("vi-VN"),
        UK_UA("uk-UA"),
        CS_CZ("cs-CZ"),
        FIL_PH("fil-PH"),
        MS_MY("ms-MY"),
        HE_IL("he-IL"),
        EL_GR("el-GR");

        private String value;

        private CoreLanguageEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CoreLanguageEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CoreLanguageEnum value : CoreLanguageEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CoreLanguageEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CoreLanguageEnumDeserializer
    extends StdDeserializer<CoreLanguageEnum> {
        public CoreLanguageEnumDeserializer() {
            super(CoreLanguageEnumDeserializer.class);
        }

        public CoreLanguageEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CoreLanguageEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

