/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DispositionAmdTimeout;
import com.mypurecloud.sdk.v2.model.DispositionParameters;
import com.mypurecloud.sdk.v2.model.DispositionSilentCallTimeout;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class Disposition
implements Serializable {
    private String name = null;
    private String analyzer = null;
    private DispositionParameters dispositionParameters = null;
    private Date detectedSpeechStart = null;
    private Date detectedSpeechEnd = null;
    private DispositionAmdTimeout amdTimeout = null;
    private DispositionSilentCallTimeout silentCallTimeout = null;

    public Disposition() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public Disposition name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the disposition. Either a platform predefined value, or the name of the disposition in the disposition table..")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Disposition analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    @ApiModelProperty(example="null", value="The final media analyzer result that triggered the disposition result, if any.")
    @JsonProperty(value="analyzer")
    public String getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public Disposition dispositionParameters(DispositionParameters dispositionParameters) {
        this.dispositionParameters = dispositionParameters;
        return this;
    }

    @ApiModelProperty(example="null", value="Contains various parameters related to call analysis.")
    @JsonProperty(value="dispositionParameters")
    public DispositionParameters getDispositionParameters() {
        return this.dispositionParameters;
    }

    public void setDispositionParameters(DispositionParameters dispositionParameters) {
        this.dispositionParameters = dispositionParameters;
    }

    public Disposition detectedSpeechStart(Date detectedSpeechStart) {
        this.detectedSpeechStart = detectedSpeechStart;
        return this;
    }

    @ApiModelProperty(example="null", value="Absolute time when the speech started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="detectedSpeechStart")
    public Date getDetectedSpeechStart() {
        return this.detectedSpeechStart;
    }

    public void setDetectedSpeechStart(Date detectedSpeechStart) {
        this.detectedSpeechStart = detectedSpeechStart;
    }

    public Disposition detectedSpeechEnd(Date detectedSpeechEnd) {
        this.detectedSpeechEnd = detectedSpeechEnd;
        return this;
    }

    @ApiModelProperty(example="null", value="Absolute time when the speech ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="detectedSpeechEnd")
    public Date getDetectedSpeechEnd() {
        return this.detectedSpeechEnd;
    }

    public void setDetectedSpeechEnd(Date detectedSpeechEnd) {
        this.detectedSpeechEnd = detectedSpeechEnd;
    }

    public Disposition amdTimeout(DispositionAmdTimeout amdTimeout) {
        this.amdTimeout = amdTimeout;
        return this;
    }

    @ApiModelProperty(example="null", value="Answering Machine Detection timeout configuration.")
    @JsonProperty(value="amdTimeout")
    public DispositionAmdTimeout getAmdTimeout() {
        return this.amdTimeout;
    }

    public void setAmdTimeout(DispositionAmdTimeout amdTimeout) {
        this.amdTimeout = amdTimeout;
    }

    public Disposition silentCallTimeout(DispositionSilentCallTimeout silentCallTimeout) {
        this.silentCallTimeout = silentCallTimeout;
        return this;
    }

    @ApiModelProperty(example="null", value="Silent Call timeout configuration.")
    @JsonProperty(value="silentCallTimeout")
    public DispositionSilentCallTimeout getSilentCallTimeout() {
        return this.silentCallTimeout;
    }

    public void setSilentCallTimeout(DispositionSilentCallTimeout silentCallTimeout) {
        this.silentCallTimeout = silentCallTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Disposition disposition = (Disposition)o;
        return Objects.equals(this.name, disposition.name) && Objects.equals(this.analyzer, disposition.analyzer) && Objects.equals(this.dispositionParameters, disposition.dispositionParameters) && Objects.equals(this.detectedSpeechStart, disposition.detectedSpeechStart) && Objects.equals(this.detectedSpeechEnd, disposition.detectedSpeechEnd) && Objects.equals(this.amdTimeout, disposition.amdTimeout) && Objects.equals(this.silentCallTimeout, disposition.silentCallTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.analyzer, this.dispositionParameters, this.detectedSpeechStart, this.detectedSpeechEnd, this.amdTimeout, this.silentCallTimeout);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Disposition {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    analyzer: ").append(this.toIndentedString(this.analyzer)).append("\n");
        sb.append("    dispositionParameters: ").append(this.toIndentedString(this.dispositionParameters)).append("\n");
        sb.append("    detectedSpeechStart: ").append(this.toIndentedString(this.detectedSpeechStart)).append("\n");
        sb.append("    detectedSpeechEnd: ").append(this.toIndentedString(this.detectedSpeechEnd)).append("\n");
        sb.append("    amdTimeout: ").append(this.toIndentedString(this.amdTimeout)).append("\n");
        sb.append("    silentCallTimeout: ").append(this.toIndentedString(this.silentCallTimeout)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

