/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AnalyticsAgentStateAgentSessionResult
implements Serializable {
    private String conversationId = null;
    private String sessionId = null;
    private Date sessionStart = null;
    private Date segmentStart = null;
    private SegmentTypeEnum segmentType = null;
    private String routedQueueId = null;
    private List<String> requestedRoutingSkillIds = null;
    private String requestedLanguageId = null;
    private OriginatingDirectionEnum originatingDirection = null;
    private MediaTypeEnum mediaType = null;

    public AnalyticsAgentStateAgentSessionResult() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.requestedRoutingSkillIds = new ArrayList<String>();
        }
    }

    public AnalyticsAgentStateAgentSessionResult conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="Conversation Id")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public AnalyticsAgentStateAgentSessionResult sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(example="null", value="Session Id")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public AnalyticsAgentStateAgentSessionResult sessionStart(Date sessionStart) {
        this.sessionStart = sessionStart;
        return this;
    }

    @ApiModelProperty(example="null", value="Session start datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="sessionStart")
    public Date getSessionStart() {
        return this.sessionStart;
    }

    public void setSessionStart(Date sessionStart) {
        this.sessionStart = sessionStart;
    }

    public AnalyticsAgentStateAgentSessionResult segmentStart(Date segmentStart) {
        this.segmentStart = segmentStart;
        return this;
    }

    @ApiModelProperty(example="null", value="Segment start datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="segmentStart")
    public Date getSegmentStart() {
        return this.segmentStart;
    }

    public void setSegmentStart(Date segmentStart) {
        this.segmentStart = segmentStart;
    }

    public AnalyticsAgentStateAgentSessionResult segmentType(SegmentTypeEnum segmentType) {
        this.segmentType = segmentType;
        return this;
    }

    @ApiModelProperty(example="null", value="Segment type")
    @JsonProperty(value="segmentType")
    public SegmentTypeEnum getSegmentType() {
        return this.segmentType;
    }

    public void setSegmentType(SegmentTypeEnum segmentType) {
        this.segmentType = segmentType;
    }

    public AnalyticsAgentStateAgentSessionResult routedQueueId(String routedQueueId) {
        this.routedQueueId = routedQueueId;
        return this;
    }

    @ApiModelProperty(example="null", value="Routed queue Id")
    @JsonProperty(value="routedQueueId")
    public String getRoutedQueueId() {
        return this.routedQueueId;
    }

    public void setRoutedQueueId(String routedQueueId) {
        this.routedQueueId = routedQueueId;
    }

    public AnalyticsAgentStateAgentSessionResult requestedRoutingSkillIds(List<String> requestedRoutingSkillIds) {
        this.requestedRoutingSkillIds = requestedRoutingSkillIds;
        return this;
    }

    @ApiModelProperty(example="null", value="List of requested routing skill Id")
    @JsonProperty(value="requestedRoutingSkillIds")
    public List<String> getRequestedRoutingSkillIds() {
        return this.requestedRoutingSkillIds;
    }

    public void setRequestedRoutingSkillIds(List<String> requestedRoutingSkillIds) {
        this.requestedRoutingSkillIds = requestedRoutingSkillIds;
    }

    public AnalyticsAgentStateAgentSessionResult requestedLanguageId(String requestedLanguageId) {
        this.requestedLanguageId = requestedLanguageId;
        return this;
    }

    @ApiModelProperty(example="null", value="Requested language Id")
    @JsonProperty(value="requestedLanguageId")
    public String getRequestedLanguageId() {
        return this.requestedLanguageId;
    }

    public void setRequestedLanguageId(String requestedLanguageId) {
        this.requestedLanguageId = requestedLanguageId;
    }

    public AnalyticsAgentStateAgentSessionResult originatingDirection(OriginatingDirectionEnum originatingDirection) {
        this.originatingDirection = originatingDirection;
        return this;
    }

    @ApiModelProperty(example="null", value="Originating direction")
    @JsonProperty(value="originatingDirection")
    public OriginatingDirectionEnum getOriginatingDirection() {
        return this.originatingDirection;
    }

    public void setOriginatingDirection(OriginatingDirectionEnum originatingDirection) {
        this.originatingDirection = originatingDirection;
    }

    public AnalyticsAgentStateAgentSessionResult mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="Media type")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsAgentStateAgentSessionResult analyticsAgentStateAgentSessionResult = (AnalyticsAgentStateAgentSessionResult)o;
        return Objects.equals(this.conversationId, analyticsAgentStateAgentSessionResult.conversationId) && Objects.equals(this.sessionId, analyticsAgentStateAgentSessionResult.sessionId) && Objects.equals(this.sessionStart, analyticsAgentStateAgentSessionResult.sessionStart) && Objects.equals(this.segmentStart, analyticsAgentStateAgentSessionResult.segmentStart) && Objects.equals((Object)this.segmentType, (Object)analyticsAgentStateAgentSessionResult.segmentType) && Objects.equals(this.routedQueueId, analyticsAgentStateAgentSessionResult.routedQueueId) && Objects.equals(this.requestedRoutingSkillIds, analyticsAgentStateAgentSessionResult.requestedRoutingSkillIds) && Objects.equals(this.requestedLanguageId, analyticsAgentStateAgentSessionResult.requestedLanguageId) && Objects.equals((Object)this.originatingDirection, (Object)analyticsAgentStateAgentSessionResult.originatingDirection) && Objects.equals((Object)this.mediaType, (Object)analyticsAgentStateAgentSessionResult.mediaType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conversationId, this.sessionId, this.sessionStart, this.segmentStart, this.segmentType, this.routedQueueId, this.requestedRoutingSkillIds, this.requestedLanguageId, this.originatingDirection, this.mediaType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsAgentStateAgentSessionResult {\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    sessionStart: ").append(this.toIndentedString(this.sessionStart)).append("\n");
        sb.append("    segmentStart: ").append(this.toIndentedString(this.segmentStart)).append("\n");
        sb.append("    segmentType: ").append(this.toIndentedString((Object)this.segmentType)).append("\n");
        sb.append("    routedQueueId: ").append(this.toIndentedString(this.routedQueueId)).append("\n");
        sb.append("    requestedRoutingSkillIds: ").append(this.toIndentedString(this.requestedRoutingSkillIds)).append("\n");
        sb.append("    requestedLanguageId: ").append(this.toIndentedString(this.requestedLanguageId)).append("\n");
        sb.append("    originatingDirection: ").append(this.toIndentedString((Object)this.originatingDirection)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SegmentTypeEnumDeserializer.class)
    public static enum SegmentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERT("alert"),
        BARGING("barging"),
        CALLBACK("callback"),
        COACHING("coaching"),
        CONTACTING("contacting"),
        CONVERTING("converting"),
        DELAY("delay"),
        DIALING("dialing"),
        HOLD("hold"),
        INTERACT("interact"),
        IVR("ivr"),
        MONITORING("monitoring"),
        PARKED("parked"),
        SCHEDULED("scheduled"),
        SCREENMONITORING("screenmonitoring"),
        SHARING("sharing"),
        SYSTEM("system"),
        TRANSMITTING("transmitting"),
        UNKNOWN("unknown"),
        UPLOADING("uploading"),
        VOICEMAIL("voicemail"),
        WRAPUP("wrapup");

        private String value;

        private SegmentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SegmentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SegmentTypeEnum value : SegmentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SegmentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=OriginatingDirectionEnumDeserializer.class)
    public static enum OriginatingDirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private OriginatingDirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OriginatingDirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OriginatingDirectionEnum value : OriginatingDirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OriginatingDirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CALLBACK("callback"),
        CHAT("chat"),
        COBROWSE("cobrowse"),
        EMAIL("email"),
        INTERNALMESSAGE("internalmessage"),
        MESSAGE("message"),
        SCREENMONITORING("screenmonitoring"),
        SCREENSHARE("screenshare"),
        UNKNOWN("unknown"),
        VIDEO("video"),
        VOICE("voice");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class OriginatingDirectionEnumDeserializer
    extends StdDeserializer<OriginatingDirectionEnum> {
        public OriginatingDirectionEnumDeserializer() {
            super(OriginatingDirectionEnumDeserializer.class);
        }

        public OriginatingDirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OriginatingDirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class SegmentTypeEnumDeserializer
    extends StdDeserializer<SegmentTypeEnum> {
        public SegmentTypeEnumDeserializer() {
            super(SegmentTypeEnumDeserializer.class);
        }

        public SegmentTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SegmentTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

