/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AlternativeShiftBuSettingsResponse
implements Serializable {
    private List<EnabledGranularitiesEnum> enabledGranularities = null;
    private Integer minMinutesBeforeStartTime = null;
    private List<RetainedActivityCategoriesEnum> retainedActivityCategories = null;
    private WfmVersionedEntityMetadata metadata = null;

    public AlternativeShiftBuSettingsResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.enabledGranularities = new ArrayList<EnabledGranularitiesEnum>();
            this.retainedActivityCategories = new ArrayList<RetainedActivityCategoriesEnum>();
        }
    }

    public AlternativeShiftBuSettingsResponse enabledGranularities(List<EnabledGranularitiesEnum> enabledGranularities) {
        this.enabledGranularities = enabledGranularities;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The granularity at which alternative shifts is allowed. An empty list means Alternative Shifts is disabled")
    @JsonProperty(value="enabledGranularities")
    public List<EnabledGranularitiesEnum> getEnabledGranularities() {
        return this.enabledGranularities;
    }

    public void setEnabledGranularities(List<EnabledGranularitiesEnum> enabledGranularities) {
        this.enabledGranularities = enabledGranularities;
    }

    public AlternativeShiftBuSettingsResponse minMinutesBeforeStartTime(Integer minMinutesBeforeStartTime) {
        this.minMinutesBeforeStartTime = minMinutesBeforeStartTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The minimum number of minutes before the start of a shift that an alternative shift can be automatically approved")
    @JsonProperty(value="minMinutesBeforeStartTime")
    public Integer getMinMinutesBeforeStartTime() {
        return this.minMinutesBeforeStartTime;
    }

    public void setMinMinutesBeforeStartTime(Integer minMinutesBeforeStartTime) {
        this.minMinutesBeforeStartTime = minMinutesBeforeStartTime;
    }

    public AlternativeShiftBuSettingsResponse retainedActivityCategories(List<RetainedActivityCategoriesEnum> retainedActivityCategories) {
        this.retainedActivityCategories = retainedActivityCategories;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Categories of activities that are required to remain at the same time slot for the alternative shifts offered. An empty list represents no retained activities")
    @JsonProperty(value="retainedActivityCategories")
    public List<RetainedActivityCategoriesEnum> getRetainedActivityCategories() {
        return this.retainedActivityCategories;
    }

    public void setRetainedActivityCategories(List<RetainedActivityCategoriesEnum> retainedActivityCategories) {
        this.retainedActivityCategories = retainedActivityCategories;
    }

    public AlternativeShiftBuSettingsResponse metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version metadata for this business unit's alternative shift settings")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlternativeShiftBuSettingsResponse alternativeShiftBuSettingsResponse = (AlternativeShiftBuSettingsResponse)o;
        return Objects.equals(this.enabledGranularities, alternativeShiftBuSettingsResponse.enabledGranularities) && Objects.equals(this.minMinutesBeforeStartTime, alternativeShiftBuSettingsResponse.minMinutesBeforeStartTime) && Objects.equals(this.retainedActivityCategories, alternativeShiftBuSettingsResponse.retainedActivityCategories) && Objects.equals(this.metadata, alternativeShiftBuSettingsResponse.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.enabledGranularities, this.minMinutesBeforeStartTime, this.retainedActivityCategories, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlternativeShiftBuSettingsResponse {\n");
        sb.append("    enabledGranularities: ").append(this.toIndentedString(this.enabledGranularities)).append("\n");
        sb.append("    minMinutesBeforeStartTime: ").append(this.toIndentedString(this.minMinutesBeforeStartTime)).append("\n");
        sb.append("    retainedActivityCategories: ").append(this.toIndentedString(this.retainedActivityCategories)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=RetainedActivityCategoriesEnumDeserializer.class)
    public static enum RetainedActivityCategoriesEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BREAK("Break"),
        MEAL("Meal"),
        MEETING("Meeting"),
        OFFQUEUEWORK("OffQueueWork"),
        TIMEOFF("TimeOff"),
        TRAINING("Training"),
        UNAVAILABLE("Unavailable");

        private String value;

        private RetainedActivityCategoriesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RetainedActivityCategoriesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RetainedActivityCategoriesEnum value : RetainedActivityCategoriesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RetainedActivityCategoriesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class RetainedActivityCategoriesEnumDeserializer
    extends StdDeserializer<RetainedActivityCategoriesEnum> {
        public RetainedActivityCategoriesEnumDeserializer() {
            super(RetainedActivityCategoriesEnumDeserializer.class);
        }

        public RetainedActivityCategoriesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RetainedActivityCategoriesEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=EnabledGranularitiesEnumDeserializer.class)
    public static enum EnabledGranularitiesEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DAILY("Daily");

        private String value;

        private EnabledGranularitiesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EnabledGranularitiesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EnabledGranularitiesEnum value : EnabledGranularitiesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EnabledGranularitiesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EnabledGranularitiesEnumDeserializer
    extends StdDeserializer<EnabledGranularitiesEnum> {
        public EnabledGranularitiesEnumDeserializer() {
            super(EnabledGranularitiesEnumDeserializer.class);
        }

        public EnabledGranularitiesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EnabledGranularitiesEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

