/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AgentMuScheduleShift;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AgentMuScheduleItem
implements Serializable {
    private UserReference agent = null;
    private List<AgentMuScheduleShift> shifts = null;
    private List<LocalDate> fullDayTimeOffMarkerDates = null;

    public AgentMuScheduleItem() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.shifts = new ArrayList<AgentMuScheduleShift>();
            this.fullDayTimeOffMarkerDates = new ArrayList<LocalDate>();
        }
    }

    public AgentMuScheduleItem agent(UserReference agent) {
        this.agent = agent;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The agent to whom this schedule applies. Note: selfUri will not be populated if retrieving result via downloadUrl")
    @JsonProperty(value="agent")
    public UserReference getAgent() {
        return this.agent;
    }

    public void setAgent(UserReference agent) {
        this.agent = agent;
    }

    public AgentMuScheduleItem shifts(List<AgentMuScheduleShift> shifts) {
        this.shifts = shifts;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The shift definitions for this agent schedule")
    @JsonProperty(value="shifts")
    public List<AgentMuScheduleShift> getShifts() {
        return this.shifts;
    }

    public void setShifts(List<AgentMuScheduleShift> shifts) {
        this.shifts = shifts;
    }

    public AgentMuScheduleItem fullDayTimeOffMarkerDates(List<LocalDate> fullDayTimeOffMarkerDates) {
        this.fullDayTimeOffMarkerDates = fullDayTimeOffMarkerDates;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The full day time off marker dates which apply to this agent schedule, interpreted in the time zone of the relevant business unit")
    @JsonProperty(value="fullDayTimeOffMarkerDates")
    public List<LocalDate> getFullDayTimeOffMarkerDates() {
        return this.fullDayTimeOffMarkerDates;
    }

    public void setFullDayTimeOffMarkerDates(List<LocalDate> fullDayTimeOffMarkerDates) {
        this.fullDayTimeOffMarkerDates = fullDayTimeOffMarkerDates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentMuScheduleItem agentMuScheduleItem = (AgentMuScheduleItem)o;
        return Objects.equals(this.agent, agentMuScheduleItem.agent) && Objects.equals(this.shifts, agentMuScheduleItem.shifts) && Objects.equals(this.fullDayTimeOffMarkerDates, agentMuScheduleItem.fullDayTimeOffMarkerDates);
    }

    public int hashCode() {
        return Objects.hash(this.agent, this.shifts, this.fullDayTimeOffMarkerDates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentMuScheduleItem {\n");
        sb.append("    agent: ").append(this.toIndentedString(this.agent)).append("\n");
        sb.append("    shifts: ").append(this.toIndentedString(this.shifts)).append("\n");
        sb.append("    fullDayTimeOffMarkerDates: ").append(this.toIndentedString(this.fullDayTimeOffMarkerDates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

