/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.JourneyViewJob;
import java.util.HashMap;
import java.util.Map;

public class PatchJourneyViewVersionJobRequest {
    private String viewId;
    private String journeyVersionId;
    private String jobId;
    private JourneyViewJob body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public PatchJourneyViewVersionJobRequest withViewId(String viewId) {
        this.setViewId(viewId);
        return this;
    }

    public String getJourneyVersionId() {
        return this.journeyVersionId;
    }

    public void setJourneyVersionId(String journeyVersionId) {
        this.journeyVersionId = journeyVersionId;
    }

    public PatchJourneyViewVersionJobRequest withJourneyVersionId(String journeyVersionId) {
        this.setJourneyVersionId(journeyVersionId);
        return this;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public PatchJourneyViewVersionJobRequest withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public JourneyViewJob getBody() {
        return this.body;
    }

    public void setBody(JourneyViewJob body) {
        this.body = body;
    }

    public PatchJourneyViewVersionJobRequest withBody(JourneyViewJob body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchJourneyViewVersionJobRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<JourneyViewJob> withHttpInfo() {
        if (this.viewId == null) {
            throw new IllegalStateException("Missing the required parameter 'viewId' when building request for PatchJourneyViewVersionJobRequest.");
        }
        if (this.journeyVersionId == null) {
            throw new IllegalStateException("Missing the required parameter 'journeyVersionId' when building request for PatchJourneyViewVersionJobRequest.");
        }
        if (this.jobId == null) {
            throw new IllegalStateException("Missing the required parameter 'jobId' when building request for PatchJourneyViewVersionJobRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchJourneyViewVersionJobRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/journey/views/{viewId}/versions/{journeyVersionId}/jobs/{jobId}").withPathParameter("viewId", this.viewId).withPathParameter("journeyVersionId", this.journeyVersionId).withPathParameter("jobId", this.jobId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String viewId, String journeyVersionId, String jobId, JourneyViewJob body) {
        return new Builder().withRequiredParams(viewId, journeyVersionId, jobId, body);
    }

    public static class Builder {
        private final PatchJourneyViewVersionJobRequest request = new PatchJourneyViewVersionJobRequest();

        private Builder() {
        }

        public Builder withViewId(String viewId) {
            this.request.setViewId(viewId);
            return this;
        }

        public Builder withJourneyVersionId(String journeyVersionId) {
            this.request.setJourneyVersionId(journeyVersionId);
            return this;
        }

        public Builder withJobId(String jobId) {
            this.request.setJobId(jobId);
            return this;
        }

        public Builder withBody(JourneyViewJob body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String viewId, String journeyVersionId, String jobId, JourneyViewJob body) {
            this.request.setViewId(viewId);
            this.request.setJourneyVersionId(journeyVersionId);
            this.request.setJobId(jobId);
            this.request.setBody(body);
            return this;
        }

        public PatchJourneyViewVersionJobRequest build() {
            if (this.request.viewId == null) {
                throw new IllegalStateException("Missing the required parameter 'viewId' when building request for PatchJourneyViewVersionJobRequest.");
            }
            if (this.request.journeyVersionId == null) {
                throw new IllegalStateException("Missing the required parameter 'journeyVersionId' when building request for PatchJourneyViewVersionJobRequest.");
            }
            if (this.request.jobId == null) {
                throw new IllegalStateException("Missing the required parameter 'jobId' when building request for PatchJourneyViewVersionJobRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchJourneyViewVersionJobRequest.");
            }
            return this.request;
        }
    }
}

