/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.EmailSettings;
import java.util.HashMap;
import java.util.Map;

public class PatchEmailsSettingsRequest {
    private EmailSettings body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public EmailSettings getBody() {
        return this.body;
    }

    public void setBody(EmailSettings body) {
        this.body = body;
    }

    public PatchEmailsSettingsRequest withBody(EmailSettings body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchEmailsSettingsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<EmailSettings> withHttpInfo() {
        return ApiRequestBuilder.create("PATCH", "/api/v2/emails/settings").withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final PatchEmailsSettingsRequest request = new PatchEmailsSettingsRequest();

        private Builder() {
        }

        public Builder withBody(EmailSettings body) {
            this.request.setBody(body);
            return this;
        }

        public PatchEmailsSettingsRequest build() {
            return this.request;
        }
    }
}

