/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.RecordingMessageReceiptReason;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class RecordingMessageReceipt
implements Serializable {
    private String id = null;
    private Date receiptTime = null;
    private StatusEnum status = null;
    private List<RecordingMessageReceiptReason> reasons = null;

    public RecordingMessageReceipt() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.reasons = new ArrayList<RecordingMessageReceiptReason>();
        }
    }

    public RecordingMessageReceipt id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the message receipt. Message receipts will have the same ID as the message they reference.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RecordingMessageReceipt receiptTime(Date receiptTime) {
        this.receiptTime = receiptTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Original time of the event (receipt). Example: delivery receipt time, read receipt time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="receiptTime")
    public Date getReceiptTime() {
        return this.receiptTime;
    }

    public void setReceiptTime(Date receiptTime) {
        this.receiptTime = receiptTime;
    }

    public RecordingMessageReceipt status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The message receipt status")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public RecordingMessageReceipt reasons(List<RecordingMessageReceiptReason> reasons) {
        this.reasons = reasons;
        return this;
    }

    @ApiModelProperty(example="null", value="List of reasons for a message receipt that indicates the message has failed. Only used with Failed status.")
    @JsonProperty(value="reasons")
    public List<RecordingMessageReceiptReason> getReasons() {
        return this.reasons;
    }

    public void setReasons(List<RecordingMessageReceiptReason> reasons) {
        this.reasons = reasons;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordingMessageReceipt recordingMessageReceipt = (RecordingMessageReceipt)o;
        return Objects.equals(this.id, recordingMessageReceipt.id) && Objects.equals(this.receiptTime, recordingMessageReceipt.receiptTime) && Objects.equals((Object)this.status, (Object)recordingMessageReceipt.status) && Objects.equals(this.reasons, recordingMessageReceipt.reasons);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.receiptTime, this.status, this.reasons});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecordingMessageReceipt {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    receiptTime: ").append(this.toIndentedString(this.receiptTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    reasons: ").append(this.toIndentedString(this.reasons)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SENT("Sent"),
        DELIVERED("Delivered"),
        READ("Read"),
        FAILED("Failed"),
        PUBLISHED("Published"),
        REMOVED("Removed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

