/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetChatsRoomParticipantRequest {
    private String roomJid;
    private String participantJid;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRoomJid() {
        return this.roomJid;
    }

    public void setRoomJid(String roomJid) {
        this.roomJid = roomJid;
    }

    public GetChatsRoomParticipantRequest withRoomJid(String roomJid) {
        this.setRoomJid(roomJid);
        return this;
    }

    public String getParticipantJid() {
        return this.participantJid;
    }

    public void setParticipantJid(String participantJid) {
        this.participantJid = participantJid;
    }

    public GetChatsRoomParticipantRequest withParticipantJid(String participantJid) {
        this.setParticipantJid(participantJid);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetChatsRoomParticipantRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.roomJid == null) {
            throw new IllegalStateException("Missing the required parameter 'roomJid' when building request for GetChatsRoomParticipantRequest.");
        }
        if (this.participantJid == null) {
            throw new IllegalStateException("Missing the required parameter 'participantJid' when building request for GetChatsRoomParticipantRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/chats/rooms/{roomJid}/participants/{participantJid}").withPathParameter("roomJid", this.roomJid).withPathParameter("participantJid", this.participantJid).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String roomJid, String participantJid) {
        return new Builder().withRequiredParams(roomJid, participantJid);
    }

    public static class Builder {
        private final GetChatsRoomParticipantRequest request = new GetChatsRoomParticipantRequest();

        private Builder() {
        }

        public Builder withRoomJid(String roomJid) {
            this.request.setRoomJid(roomJid);
            return this;
        }

        public Builder withParticipantJid(String participantJid) {
            this.request.setParticipantJid(participantJid);
            return this;
        }

        public Builder withRequiredParams(String roomJid, String participantJid) {
            this.request.setRoomJid(roomJid);
            this.request.setParticipantJid(participantJid);
            return this;
        }

        public GetChatsRoomParticipantRequest build() {
            if (this.request.roomJid == null) {
                throw new IllegalStateException("Missing the required parameter 'roomJid' when building request for GetChatsRoomParticipantRequest.");
            }
            if (this.request.participantJid == null) {
                throw new IllegalStateException("Missing the required parameter 'participantJid' when building request for GetChatsRoomParticipantRequest.");
            }
            return this.request;
        }
    }
}

