/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Button response object representing the click of a structured message button, such as a quick reply.")
public class WebMessagingButtonResponse
implements Serializable {
    private String id = null;
    private TypeEnum type = null;
    private String text = null;
    private String payload = null;
    private String originatingMessageId = null;

    public WebMessagingButtonResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public WebMessagingButtonResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="An ID assigned to the button response (Deprecated).")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WebMessagingButtonResponse type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Describes the button that resulted in the Button Response.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public WebMessagingButtonResponse text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The response text from the button click.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public WebMessagingButtonResponse payload(String payload) {
        this.payload = payload;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The response payload associated with the clicked button.")
    @JsonProperty(value="payload")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public WebMessagingButtonResponse originatingMessageId(String originatingMessageId) {
        this.originatingMessageId = originatingMessageId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Id of original structured message that this message responds to.")
    @JsonProperty(value="originatingMessageId")
    public String getOriginatingMessageId() {
        return this.originatingMessageId;
    }

    public void setOriginatingMessageId(String originatingMessageId) {
        this.originatingMessageId = originatingMessageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebMessagingButtonResponse webMessagingButtonResponse = (WebMessagingButtonResponse)o;
        return Objects.equals(this.id, webMessagingButtonResponse.id) && Objects.equals((Object)this.type, (Object)webMessagingButtonResponse.type) && Objects.equals(this.text, webMessagingButtonResponse.text) && Objects.equals(this.payload, webMessagingButtonResponse.payload) && Objects.equals(this.originatingMessageId, webMessagingButtonResponse.originatingMessageId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.text, this.payload, this.originatingMessageId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebMessagingButtonResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    originatingMessageId: ").append(this.toIndentedString(this.originatingMessageId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BUTTON("Button"),
        QUICKREPLY("QuickReply"),
        DATEPICKER("DatePicker"),
        LISTPICKER("ListPicker");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

