/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class MessageMediaData
implements Serializable {
    private String id = null;
    private String name = null;
    private String url = null;
    private String mediaType = null;
    private Integer contentLengthBytes = null;
    private String uploadUrl = null;
    private StatusEnum status = null;
    private String conversationId = null;
    private String communicationId = null;
    private String selfUri = null;

    public MessageMediaData() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public MessageMediaData name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MessageMediaData url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="null", value="The location of the media, useful for retrieving it")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public MessageMediaData mediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="The detected internet media type of the the media object.  If null then the media type should be dictated by the url.")
    @JsonProperty(value="mediaType")
    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public MessageMediaData contentLengthBytes(Integer contentLengthBytes) {
        this.contentLengthBytes = contentLengthBytes;
        return this;
    }

    @ApiModelProperty(example="null", value="The optional content length of the the media object, in bytes.")
    @JsonProperty(value="contentLengthBytes")
    public Integer getContentLengthBytes() {
        return this.contentLengthBytes;
    }

    public void setContentLengthBytes(Integer contentLengthBytes) {
        this.contentLengthBytes = contentLengthBytes;
    }

    public MessageMediaData uploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="The URL returned to upload an attachment")
    @JsonProperty(value="uploadUrl")
    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
    }

    @ApiModelProperty(example="null", value="The status of the media, indicates if the media is in the process of uploading. If the upload fails, the media becomes invalid")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public MessageMediaData conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public MessageMediaData communicationId(String communicationId) {
        this.communicationId = communicationId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="communicationId")
    public String getCommunicationId() {
        return this.communicationId;
    }

    public void setCommunicationId(String communicationId) {
        this.communicationId = communicationId;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageMediaData messageMediaData = (MessageMediaData)o;
        return Objects.equals(this.id, messageMediaData.id) && Objects.equals(this.name, messageMediaData.name) && Objects.equals(this.url, messageMediaData.url) && Objects.equals(this.mediaType, messageMediaData.mediaType) && Objects.equals(this.contentLengthBytes, messageMediaData.contentLengthBytes) && Objects.equals(this.uploadUrl, messageMediaData.uploadUrl) && Objects.equals((Object)this.status, (Object)messageMediaData.status) && Objects.equals(this.conversationId, messageMediaData.conversationId) && Objects.equals(this.communicationId, messageMediaData.communicationId) && Objects.equals(this.selfUri, messageMediaData.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.url, this.mediaType, this.contentLengthBytes, this.uploadUrl, this.status, this.conversationId, this.communicationId, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageMediaData {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("    contentLengthBytes: ").append(this.toIndentedString(this.contentLengthBytes)).append("\n");
        sb.append("    uploadUrl: ").append(this.toIndentedString(this.uploadUrl)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    communicationId: ").append(this.toIndentedString(this.communicationId)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UPLOADING("uploading"),
        VALID("valid"),
        INVALID("invalid");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

