/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="The representation of a case association on a journey session.")
public class JourneyCaseAssociation
implements Serializable {
    private String id = null;
    private AddressableEntityRef associatedCase = null;
    private String caseReference = null;
    private Date dateAssociated = null;
    private String selfUri = null;

    public JourneyCaseAssociation() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public JourneyCaseAssociation id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the association.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JourneyCaseAssociation associatedCase(AddressableEntityRef associatedCase) {
        this.associatedCase = associatedCase;
        return this;
    }

    @ApiModelProperty(example="null", value="The case that was associated with the journey session.")
    @JsonProperty(value="associatedCase")
    public AddressableEntityRef getAssociatedCase() {
        return this.associatedCase;
    }

    public void setAssociatedCase(AddressableEntityRef associatedCase) {
        this.associatedCase = associatedCase;
    }

    public JourneyCaseAssociation caseReference(String caseReference) {
        this.caseReference = caseReference;
        return this;
    }

    @ApiModelProperty(example="null", value="The reference for the case that was associated with the journey session.")
    @JsonProperty(value="caseReference")
    public String getCaseReference() {
        return this.caseReference;
    }

    public void setCaseReference(String caseReference) {
        this.caseReference = caseReference;
    }

    public JourneyCaseAssociation dateAssociated(Date dateAssociated) {
        this.dateAssociated = dateAssociated;
        return this;
    }

    @ApiModelProperty(example="null", value="The date of the association. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateAssociated")
    public Date getDateAssociated() {
        return this.dateAssociated;
    }

    public void setDateAssociated(Date dateAssociated) {
        this.dateAssociated = dateAssociated;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JourneyCaseAssociation journeyCaseAssociation = (JourneyCaseAssociation)o;
        return Objects.equals(this.id, journeyCaseAssociation.id) && Objects.equals(this.associatedCase, journeyCaseAssociation.associatedCase) && Objects.equals(this.caseReference, journeyCaseAssociation.caseReference) && Objects.equals(this.dateAssociated, journeyCaseAssociation.dateAssociated) && Objects.equals(this.selfUri, journeyCaseAssociation.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.associatedCase, this.caseReference, this.dateAssociated, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JourneyCaseAssociation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    associatedCase: ").append(this.toIndentedString(this.associatedCase)).append("\n");
        sb.append("    caseReference: ").append(this.toIndentedString(this.caseReference)).append("\n");
        sb.append("    dateAssociated: ").append(this.toIndentedString(this.dateAssociated)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

