/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AgentChecklistInfo;
import com.mypurecloud.sdk.v2.model.ErrorInfo;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class ChecklistInferenceJobResponse
implements Serializable {
    private String id = null;
    private StatusEnum status = null;
    private ErrorInfo error = null;
    private AgentChecklistInfo agentChecklistInfo = null;
    private Date jobStartTime = null;
    private Date jobEndTime = null;
    private String language = null;
    private String agentId = null;
    private String participantId = null;
    private String queueId = null;
    private String assistantId = null;
    private MediaTypeEnum mediaType = null;
    private DirectionEnum direction = null;
    private String selfUri = null;

    public ChecklistInferenceJobResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ChecklistInferenceJobResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the inference job.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ChecklistInferenceJobResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Status of the checklist inference job.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ChecklistInferenceJobResponse error(ErrorInfo error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(example="null", value="Error information associated with a job in case of any errors.")
    @JsonProperty(value="error")
    public ErrorInfo getError() {
        return this.error;
    }

    public void setError(ErrorInfo error) {
        this.error = error;
    }

    public ChecklistInferenceJobResponse agentChecklistInfo(AgentChecklistInfo agentChecklistInfo) {
        this.agentChecklistInfo = agentChecklistInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="Agent checklist info.")
    @JsonProperty(value="agentChecklistInfo")
    public AgentChecklistInfo getAgentChecklistInfo() {
        return this.agentChecklistInfo;
    }

    public void setAgentChecklistInfo(AgentChecklistInfo agentChecklistInfo) {
        this.agentChecklistInfo = agentChecklistInfo;
    }

    public ChecklistInferenceJobResponse jobStartTime(Date jobStartTime) {
        this.jobStartTime = jobStartTime;
        return this;
    }

    @ApiModelProperty(example="2025-08-06T03:52:10.150Z", value="Date when the inference job started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="jobStartTime")
    public Date getJobStartTime() {
        return this.jobStartTime;
    }

    public void setJobStartTime(Date jobStartTime) {
        this.jobStartTime = jobStartTime;
    }

    public ChecklistInferenceJobResponse jobEndTime(Date jobEndTime) {
        this.jobEndTime = jobEndTime;
        return this;
    }

    @ApiModelProperty(example="2025-08-06T03:52:10.150Z", value="Date when the inference job finished. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="jobEndTime")
    public Date getJobEndTime() {
        return this.jobEndTime;
    }

    public void setJobEndTime(Date jobEndTime) {
        this.jobEndTime = jobEndTime;
    }

    public ChecklistInferenceJobResponse language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", value="Language associated with the checklist.")
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public ChecklistInferenceJobResponse agentId(String agentId) {
        this.agentId = agentId;
        return this;
    }

    @ApiModelProperty(example="null", value="Agent ID.")
    @JsonProperty(value="agentId")
    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public ChecklistInferenceJobResponse participantId(String participantId) {
        this.participantId = participantId;
        return this;
    }

    @ApiModelProperty(example="null", value="Participant ID.")
    @JsonProperty(value="participantId")
    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public ChecklistInferenceJobResponse queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", value="Queue ID.")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public ChecklistInferenceJobResponse assistantId(String assistantId) {
        this.assistantId = assistantId;
        return this;
    }

    @ApiModelProperty(example="null", value="Assistant ID.")
    @JsonProperty(value="assistantId")
    public String getAssistantId() {
        return this.assistantId;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public ChecklistInferenceJobResponse mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="Media type.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public ChecklistInferenceJobResponse direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="Direction of the conversation.")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChecklistInferenceJobResponse checklistInferenceJobResponse = (ChecklistInferenceJobResponse)o;
        return Objects.equals(this.id, checklistInferenceJobResponse.id) && Objects.equals((Object)this.status, (Object)checklistInferenceJobResponse.status) && Objects.equals(this.error, checklistInferenceJobResponse.error) && Objects.equals(this.agentChecklistInfo, checklistInferenceJobResponse.agentChecklistInfo) && Objects.equals(this.jobStartTime, checklistInferenceJobResponse.jobStartTime) && Objects.equals(this.jobEndTime, checklistInferenceJobResponse.jobEndTime) && Objects.equals(this.language, checklistInferenceJobResponse.language) && Objects.equals(this.agentId, checklistInferenceJobResponse.agentId) && Objects.equals(this.participantId, checklistInferenceJobResponse.participantId) && Objects.equals(this.queueId, checklistInferenceJobResponse.queueId) && Objects.equals(this.assistantId, checklistInferenceJobResponse.assistantId) && Objects.equals((Object)this.mediaType, (Object)checklistInferenceJobResponse.mediaType) && Objects.equals((Object)this.direction, (Object)checklistInferenceJobResponse.direction) && Objects.equals(this.selfUri, checklistInferenceJobResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status, this.error, this.agentChecklistInfo, this.jobStartTime, this.jobEndTime, this.language, this.agentId, this.participantId, this.queueId, this.assistantId, this.mediaType, this.direction, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChecklistInferenceJobResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    agentChecklistInfo: ").append(this.toIndentedString(this.agentChecklistInfo)).append("\n");
        sb.append("    jobStartTime: ").append(this.toIndentedString(this.jobStartTime)).append("\n");
        sb.append("    jobEndTime: ").append(this.toIndentedString(this.jobEndTime)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    agentId: ").append(this.toIndentedString(this.agentId)).append("\n");
        sb.append("    participantId: ").append(this.toIndentedString(this.participantId)).append("\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    assistantId: ").append(this.toIndentedString(this.assistantId)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PROCESSING("Processing"),
        ERROR("Error"),
        COMPLETE("Complete");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        VOICE("Voice"),
        MESSAGE("Message"),
        EMAIL("Email");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("Inbound"),
        OUTBOUND("Outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

