/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetAssistantCopilotRequest;
import com.mypurecloud.sdk.v2.api.request.GetAssistantsCopilotFeaturesupportRequest;
import com.mypurecloud.sdk.v2.api.request.PutAssistantCopilotRequest;
import com.mypurecloud.sdk.v2.model.Copilot;
import com.mypurecloud.sdk.v2.model.LanguageSupportResponse;
import java.io.IOException;

public class AgentCopilotApi {
    private final ApiClient pcapiClient;

    public AgentCopilotApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AgentCopilotApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public Copilot getAssistantCopilot(String assistantId) throws IOException, ApiException {
        return this.getAssistantCopilot(this.createGetAssistantCopilotRequest(assistantId));
    }

    public ApiResponse<Copilot> getAssistantCopilotWithHttpInfo(String assistantId) throws IOException {
        return this.getAssistantCopilot(this.createGetAssistantCopilotRequest(assistantId).withHttpInfo());
    }

    private GetAssistantCopilotRequest createGetAssistantCopilotRequest(String assistantId) {
        return GetAssistantCopilotRequest.builder().withAssistantId(assistantId).build();
    }

    public Copilot getAssistantCopilot(GetAssistantCopilotRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Copilot> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Copilot>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Copilot> getAssistantCopilot(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Copilot>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LanguageSupportResponse getAssistantsCopilotFeaturesupport(String language) throws IOException, ApiException {
        return this.getAssistantsCopilotFeaturesupport(this.createGetAssistantsCopilotFeaturesupportRequest(language));
    }

    public ApiResponse<LanguageSupportResponse> getAssistantsCopilotFeaturesupportWithHttpInfo(String language) throws IOException {
        return this.getAssistantsCopilotFeaturesupport(this.createGetAssistantsCopilotFeaturesupportRequest(language).withHttpInfo());
    }

    private GetAssistantsCopilotFeaturesupportRequest createGetAssistantsCopilotFeaturesupportRequest(String language) {
        return GetAssistantsCopilotFeaturesupportRequest.builder().withLanguage(language).build();
    }

    public LanguageSupportResponse getAssistantsCopilotFeaturesupport(GetAssistantsCopilotFeaturesupportRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LanguageSupportResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LanguageSupportResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LanguageSupportResponse> getAssistantsCopilotFeaturesupport(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LanguageSupportResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Copilot putAssistantCopilot(String assistantId, Copilot body) throws IOException, ApiException {
        return this.putAssistantCopilot(this.createPutAssistantCopilotRequest(assistantId, body));
    }

    public ApiResponse<Copilot> putAssistantCopilotWithHttpInfo(String assistantId, Copilot body) throws IOException {
        return this.putAssistantCopilot(this.createPutAssistantCopilotRequest(assistantId, body).withHttpInfo());
    }

    private PutAssistantCopilotRequest createPutAssistantCopilotRequest(String assistantId, Copilot body) {
        return PutAssistantCopilotRequest.builder().withAssistantId(assistantId).withBody(body).build();
    }

    public Copilot putAssistantCopilot(PutAssistantCopilotRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Copilot> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Copilot>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Copilot> putAssistantCopilot(ApiRequest<Copilot> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Copilot>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

