/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class GetRulesQuery
implements Serializable {
    private RuleTypeEnum ruleType = null;
    private QueryTypeEnum queryType = null;
    private EnabledTypeEnum enabledType = null;
    private Integer pageNumber = null;
    private Integer pageSize = null;
    private SortByEnum sortBy = null;
    private SortOrderEnum sortOrder = null;
    private String ruleName = null;
    private NameSearchTypeEnum nameSearchType = null;

    public GetRulesQuery() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public GetRulesQuery ruleType(RuleTypeEnum ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The rule type of the alerts the query will return")
    @JsonProperty(value="ruleType")
    public RuleTypeEnum getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(RuleTypeEnum ruleType) {
        this.ruleType = ruleType;
    }

    public GetRulesQuery queryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of query being performed.")
    @JsonProperty(value="queryType")
    public QueryTypeEnum getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
    }

    public GetRulesQuery enabledType(EnabledTypeEnum enabledType) {
        this.enabledType = enabledType;
        return this;
    }

    @ApiModelProperty(example="null", value="The state of the rule the query will return.  The accepted choices are Enabled, Disabled, or All")
    @JsonProperty(value="enabledType")
    public EnabledTypeEnum getEnabledType() {
        return this.enabledType;
    }

    public void setEnabledType(EnabledTypeEnum enabledType) {
        this.enabledType = enabledType;
    }

    public GetRulesQuery pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="The page number of the queried response")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public GetRulesQuery pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of entities to return of the queried response.  The max is 25")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public GetRulesQuery sortBy(SortByEnum sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The field to sort responses by.  The accepted choices are Name and DateStart")
    @JsonProperty(value="sortBy")
    public SortByEnum getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(SortByEnum sortBy) {
        this.sortBy = sortBy;
    }

    public GetRulesQuery sortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="The order in which response will be sorted.  The accepted choices are Asc and Desc")
    @JsonProperty(value="sortOrder")
    public SortOrderEnum getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
    }

    public GetRulesQuery ruleName(String ruleName) {
        this.ruleName = ruleName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the rule being queries.")
    @JsonProperty(value="ruleName")
    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public GetRulesQuery nameSearchType(NameSearchTypeEnum nameSearchType) {
        this.nameSearchType = nameSearchType;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies how strict the name search needs to be. Expected values are Exact and Contains if querying by name.")
    @JsonProperty(value="nameSearchType")
    public NameSearchTypeEnum getNameSearchType() {
        return this.nameSearchType;
    }

    public void setNameSearchType(NameSearchTypeEnum nameSearchType) {
        this.nameSearchType = nameSearchType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetRulesQuery getRulesQuery = (GetRulesQuery)o;
        return Objects.equals((Object)this.ruleType, (Object)getRulesQuery.ruleType) && Objects.equals((Object)this.queryType, (Object)getRulesQuery.queryType) && Objects.equals((Object)this.enabledType, (Object)getRulesQuery.enabledType) && Objects.equals(this.pageNumber, getRulesQuery.pageNumber) && Objects.equals(this.pageSize, getRulesQuery.pageSize) && Objects.equals((Object)this.sortBy, (Object)getRulesQuery.sortBy) && Objects.equals((Object)this.sortOrder, (Object)getRulesQuery.sortOrder) && Objects.equals(this.ruleName, getRulesQuery.ruleName) && Objects.equals((Object)this.nameSearchType, (Object)getRulesQuery.nameSearchType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ruleType, this.queryType, this.enabledType, this.pageNumber, this.pageSize, this.sortBy, this.sortOrder, this.ruleName, this.nameSearchType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetRulesQuery {\n");
        sb.append("    ruleType: ").append(this.toIndentedString((Object)this.ruleType)).append("\n");
        sb.append("    queryType: ").append(this.toIndentedString((Object)this.queryType)).append("\n");
        sb.append("    enabledType: ").append(this.toIndentedString((Object)this.enabledType)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    sortBy: ").append(this.toIndentedString((Object)this.sortBy)).append("\n");
        sb.append("    sortOrder: ").append(this.toIndentedString((Object)this.sortOrder)).append("\n");
        sb.append("    ruleName: ").append(this.toIndentedString(this.ruleName)).append("\n");
        sb.append("    nameSearchType: ").append(this.toIndentedString((Object)this.nameSearchType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=RuleTypeEnumDeserializer.class)
    public static enum RuleTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CONVERSATION("Conversation"),
        PRESENCE("Presence"),
        ALL("All");

        private String value;

        private RuleTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RuleTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RuleTypeEnum value : RuleTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RuleTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=QueryTypeEnumDeserializer.class)
    public static enum QueryTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INFO("Info"),
        COUNT("Count");

        private String value;

        private QueryTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static QueryTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (QueryTypeEnum value : QueryTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return QueryTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=EnabledTypeEnumDeserializer.class)
    public static enum EnabledTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENABLED("Enabled"),
        DISABLED("Disabled"),
        ALL("All");

        private String value;

        private EnabledTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EnabledTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EnabledTypeEnum value : EnabledTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EnabledTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SortByEnumDeserializer.class)
    public static enum SortByEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NAME("Name"),
        DATECREATED("DateCreated");

        private String value;

        private SortByEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SortByEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SortByEnum value : SortByEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SortByEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SortOrderEnumDeserializer.class)
    public static enum SortOrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("Asc"),
        DESC("Desc");

        private String value;

        private SortOrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SortOrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SortOrderEnum value : SortOrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SortOrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=NameSearchTypeEnumDeserializer.class)
    public static enum NameSearchTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EXACT("Exact"),
        CONTAINS("Contains"),
        UNKNOWN("Unknown");

        private String value;

        private NameSearchTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static NameSearchTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (NameSearchTypeEnum value : NameSearchTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return NameSearchTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class NameSearchTypeEnumDeserializer
    extends StdDeserializer<NameSearchTypeEnum> {
        public NameSearchTypeEnumDeserializer() {
            super(NameSearchTypeEnumDeserializer.class);
        }

        public NameSearchTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return NameSearchTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class SortOrderEnumDeserializer
    extends StdDeserializer<SortOrderEnum> {
        public SortOrderEnumDeserializer() {
            super(SortOrderEnumDeserializer.class);
        }

        public SortOrderEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SortOrderEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class SortByEnumDeserializer
    extends StdDeserializer<SortByEnum> {
        public SortByEnumDeserializer() {
            super(SortByEnumDeserializer.class);
        }

        public SortByEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SortByEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class EnabledTypeEnumDeserializer
    extends StdDeserializer<EnabledTypeEnum> {
        public EnabledTypeEnumDeserializer() {
            super(EnabledTypeEnumDeserializer.class);
        }

        public EnabledTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EnabledTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class QueryTypeEnumDeserializer
    extends StdDeserializer<QueryTypeEnum> {
        public QueryTypeEnumDeserializer() {
            super(QueryTypeEnumDeserializer.class);
        }

        public QueryTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return QueryTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class RuleTypeEnumDeserializer
    extends StdDeserializer<RuleTypeEnum> {
        public RuleTypeEnumDeserializer() {
            super(RuleTypeEnumDeserializer.class);
        }

        public RuleTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RuleTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

