/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AfterCallWork;
import com.mypurecloud.sdk.v2.model.ConversationQueueMediaSettings;
import com.mypurecloud.sdk.v2.model.DialerPreview;
import com.mypurecloud.sdk.v2.model.Segment;
import com.mypurecloud.sdk.v2.model.Voicemail;
import com.mypurecloud.sdk.v2.model.Wrapup;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CallbackBasic
implements Serializable {
    private StateEnum state = null;
    private InitialStateEnum initialState = null;
    private String id = null;
    private List<Segment> segments = null;
    private DirectionEnum direction = null;
    private Boolean held = null;
    private DisconnectTypeEnum disconnectType = null;
    private Date startHoldTime = null;
    private DialerPreview dialerPreview = null;
    private Voicemail voicemail = null;
    private List<String> callbackNumbers = null;
    private String callbackUserName = null;
    private String scriptId = null;
    private Boolean externalCampaign = null;
    private Boolean skipEnabled = null;
    private Integer timeoutSeconds = null;
    private Date startAlertingTime = null;
    private Date connectedTime = null;
    private Date disconnectedTime = null;
    private Date callbackScheduledTime = null;
    private String automatedCallbackConfigId = null;
    private String provider = null;
    private String peerId = null;
    private Wrapup wrapup = null;
    private AfterCallWork afterCallWork = null;
    private Boolean afterCallWorkRequired = null;
    private String callerId = null;
    private String callerIdName = null;
    private ConversationQueueMediaSettings queueMediaSettings = null;

    public CallbackBasic() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.segments = new ArrayList<Segment>();
            this.callbackNumbers = new ArrayList<String>();
        }
    }

    public CallbackBasic state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The connection state of this communication.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public CallbackBasic initialState(InitialStateEnum initialState) {
        this.initialState = initialState;
        return this;
    }

    @ApiModelProperty(example="null", value="The initial connection state of this communication.")
    @JsonProperty(value="initialState")
    public InitialStateEnum getInitialState() {
        return this.initialState;
    }

    public void setInitialState(InitialStateEnum initialState) {
        this.initialState = initialState;
    }

    public CallbackBasic id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for this communication.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CallbackBasic segments(List<Segment> segments) {
        this.segments = segments;
        return this;
    }

    @ApiModelProperty(example="null", value="The time line of the participant's callback, divided into activity segments.")
    @JsonProperty(value="segments")
    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }

    public CallbackBasic direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The direction of the call")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public CallbackBasic held(Boolean held) {
        this.held = held;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this call is held and the person on this side hears silence.")
    @JsonProperty(value="held")
    public Boolean getHeld() {
        return this.held;
    }

    public void setHeld(Boolean held) {
        this.held = held;
    }

    public CallbackBasic disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public CallbackBasic startHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp the callback was placed on hold in the cloud clock if the callback is currently on hold. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startHoldTime")
    public Date getStartHoldTime() {
        return this.startHoldTime;
    }

    public void setStartHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
    }

    public CallbackBasic dialerPreview(DialerPreview dialerPreview) {
        this.dialerPreview = dialerPreview;
        return this;
    }

    @ApiModelProperty(example="null", value="The preview data to be used when this callback is a Preview.")
    @JsonProperty(value="dialerPreview")
    public DialerPreview getDialerPreview() {
        return this.dialerPreview;
    }

    public void setDialerPreview(DialerPreview dialerPreview) {
        this.dialerPreview = dialerPreview;
    }

    public CallbackBasic voicemail(Voicemail voicemail) {
        this.voicemail = voicemail;
        return this;
    }

    @ApiModelProperty(example="null", value="The voicemail data to be used when this callback is an ACD voicemail.")
    @JsonProperty(value="voicemail")
    public Voicemail getVoicemail() {
        return this.voicemail;
    }

    public void setVoicemail(Voicemail voicemail) {
        this.voicemail = voicemail;
    }

    public CallbackBasic callbackNumbers(List<String> callbackNumbers) {
        this.callbackNumbers = callbackNumbers;
        return this;
    }

    @ApiModelProperty(example="null", value="The phone number(s) to use to place the callback.")
    @JsonProperty(value="callbackNumbers")
    public List<String> getCallbackNumbers() {
        return this.callbackNumbers;
    }

    public void setCallbackNumbers(List<String> callbackNumbers) {
        this.callbackNumbers = callbackNumbers;
    }

    public CallbackBasic callbackUserName(String callbackUserName) {
        this.callbackUserName = callbackUserName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the user requesting a callback.")
    @JsonProperty(value="callbackUserName")
    public String getCallbackUserName() {
        return this.callbackUserName;
    }

    public void setCallbackUserName(String callbackUserName) {
        this.callbackUserName = callbackUserName;
    }

    public CallbackBasic scriptId(String scriptId) {
        this.scriptId = scriptId;
        return this;
    }

    @ApiModelProperty(example="null", value="The UUID of the script to use.")
    @JsonProperty(value="scriptId")
    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public CallbackBasic externalCampaign(Boolean externalCampaign) {
        this.externalCampaign = externalCampaign;
        return this;
    }

    @ApiModelProperty(example="null", value="True if the call for the callback uses external dialing.")
    @JsonProperty(value="externalCampaign")
    public Boolean getExternalCampaign() {
        return this.externalCampaign;
    }

    public void setExternalCampaign(Boolean externalCampaign) {
        this.externalCampaign = externalCampaign;
    }

    public CallbackBasic skipEnabled(Boolean skipEnabled) {
        this.skipEnabled = skipEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="True if the ability to skip a callback should be enabled.")
    @JsonProperty(value="skipEnabled")
    public Boolean getSkipEnabled() {
        return this.skipEnabled;
    }

    public void setSkipEnabled(Boolean skipEnabled) {
        this.skipEnabled = skipEnabled;
    }

    public CallbackBasic timeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of seconds before the system automatically places a call for a callback.  0 means the automatic placement is disabled.")
    @JsonProperty(value="timeoutSeconds")
    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public CallbackBasic startAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp the communication has when it is first put into an alerting state. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startAlertingTime")
    public Date getStartAlertingTime() {
        return this.startAlertingTime;
    }

    public void setStartAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
    }

    public CallbackBasic connectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="connectedTime")
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
    }

    public CallbackBasic disconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="disconnectedTime")
    public Date getDisconnectedTime() {
        return this.disconnectedTime;
    }

    public void setDisconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
    }

    public CallbackBasic callbackScheduledTime(Date callbackScheduledTime) {
        this.callbackScheduledTime = callbackScheduledTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication is scheduled in the provider clock. If this value is missing it indicates the callback will be placed immediately. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="callbackScheduledTime")
    public Date getCallbackScheduledTime() {
        return this.callbackScheduledTime;
    }

    public void setCallbackScheduledTime(Date callbackScheduledTime) {
        this.callbackScheduledTime = callbackScheduledTime;
    }

    public CallbackBasic automatedCallbackConfigId(String automatedCallbackConfigId) {
        this.automatedCallbackConfigId = automatedCallbackConfigId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the config for automatically placing the callback (and handling the disposition). If null, the callback will not be placed automatically but routed to an agent as per normal.")
    @JsonProperty(value="automatedCallbackConfigId")
    public String getAutomatedCallbackConfigId() {
        return this.automatedCallbackConfigId;
    }

    public void setAutomatedCallbackConfigId(String automatedCallbackConfigId) {
        this.automatedCallbackConfigId = automatedCallbackConfigId;
    }

    public CallbackBasic provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider for the callback.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public CallbackBasic peerId(String peerId) {
        this.peerId = peerId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the peer communication corresponding to a matching leg for this communication.")
    @JsonProperty(value="peerId")
    public String getPeerId() {
        return this.peerId;
    }

    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    public CallbackBasic wrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
        return this;
    }

    @ApiModelProperty(example="null", value="Call wrap up or disposition data.")
    @JsonProperty(value="wrapup")
    public Wrapup getWrapup() {
        return this.wrapup;
    }

    public void setWrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
    }

    public CallbackBasic afterCallWork(AfterCallWork afterCallWork) {
        this.afterCallWork = afterCallWork;
        return this;
    }

    @ApiModelProperty(example="null", value="After-call work for the communication.")
    @JsonProperty(value="afterCallWork")
    public AfterCallWork getAfterCallWork() {
        return this.afterCallWork;
    }

    public void setAfterCallWork(AfterCallWork afterCallWork) {
        this.afterCallWork = afterCallWork;
    }

    public CallbackBasic afterCallWorkRequired(Boolean afterCallWorkRequired) {
        this.afterCallWorkRequired = afterCallWorkRequired;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if after-call work is required for a communication. Only used when the ACW Setting is Agent Requested.")
    @JsonProperty(value="afterCallWorkRequired")
    public Boolean getAfterCallWorkRequired() {
        return this.afterCallWorkRequired;
    }

    public void setAfterCallWorkRequired(Boolean afterCallWorkRequired) {
        this.afterCallWorkRequired = afterCallWorkRequired;
    }

    public CallbackBasic callerId(String callerId) {
        this.callerId = callerId;
        return this;
    }

    @ApiModelProperty(example="null", value="The phone number displayed to recipients of the phone call. The value should conform to the E164 format.")
    @JsonProperty(value="callerId")
    public String getCallerId() {
        return this.callerId;
    }

    public void setCallerId(String callerId) {
        this.callerId = callerId;
    }

    public CallbackBasic callerIdName(String callerIdName) {
        this.callerIdName = callerIdName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name displayed to recipients of the phone call.")
    @JsonProperty(value="callerIdName")
    public String getCallerIdName() {
        return this.callerIdName;
    }

    public void setCallerIdName(String callerIdName) {
        this.callerIdName = callerIdName;
    }

    public CallbackBasic queueMediaSettings(ConversationQueueMediaSettings queueMediaSettings) {
        this.queueMediaSettings = queueMediaSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the queue settings for this media type.")
    @JsonProperty(value="queueMediaSettings")
    public ConversationQueueMediaSettings getQueueMediaSettings() {
        return this.queueMediaSettings;
    }

    public void setQueueMediaSettings(ConversationQueueMediaSettings queueMediaSettings) {
        this.queueMediaSettings = queueMediaSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallbackBasic callbackBasic = (CallbackBasic)o;
        return Objects.equals((Object)this.state, (Object)callbackBasic.state) && Objects.equals((Object)this.initialState, (Object)callbackBasic.initialState) && Objects.equals(this.id, callbackBasic.id) && Objects.equals(this.segments, callbackBasic.segments) && Objects.equals((Object)this.direction, (Object)callbackBasic.direction) && Objects.equals(this.held, callbackBasic.held) && Objects.equals((Object)this.disconnectType, (Object)callbackBasic.disconnectType) && Objects.equals(this.startHoldTime, callbackBasic.startHoldTime) && Objects.equals(this.dialerPreview, callbackBasic.dialerPreview) && Objects.equals(this.voicemail, callbackBasic.voicemail) && Objects.equals(this.callbackNumbers, callbackBasic.callbackNumbers) && Objects.equals(this.callbackUserName, callbackBasic.callbackUserName) && Objects.equals(this.scriptId, callbackBasic.scriptId) && Objects.equals(this.externalCampaign, callbackBasic.externalCampaign) && Objects.equals(this.skipEnabled, callbackBasic.skipEnabled) && Objects.equals(this.timeoutSeconds, callbackBasic.timeoutSeconds) && Objects.equals(this.startAlertingTime, callbackBasic.startAlertingTime) && Objects.equals(this.connectedTime, callbackBasic.connectedTime) && Objects.equals(this.disconnectedTime, callbackBasic.disconnectedTime) && Objects.equals(this.callbackScheduledTime, callbackBasic.callbackScheduledTime) && Objects.equals(this.automatedCallbackConfigId, callbackBasic.automatedCallbackConfigId) && Objects.equals(this.provider, callbackBasic.provider) && Objects.equals(this.peerId, callbackBasic.peerId) && Objects.equals(this.wrapup, callbackBasic.wrapup) && Objects.equals(this.afterCallWork, callbackBasic.afterCallWork) && Objects.equals(this.afterCallWorkRequired, callbackBasic.afterCallWorkRequired) && Objects.equals(this.callerId, callbackBasic.callerId) && Objects.equals(this.callerIdName, callbackBasic.callerIdName) && Objects.equals(this.queueMediaSettings, callbackBasic.queueMediaSettings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.initialState, this.id, this.segments, this.direction, this.held, this.disconnectType, this.startHoldTime, this.dialerPreview, this.voicemail, this.callbackNumbers, this.callbackUserName, this.scriptId, this.externalCampaign, this.skipEnabled, this.timeoutSeconds, this.startAlertingTime, this.connectedTime, this.disconnectedTime, this.callbackScheduledTime, this.automatedCallbackConfigId, this.provider, this.peerId, this.wrapup, this.afterCallWork, this.afterCallWorkRequired, this.callerId, this.callerIdName, this.queueMediaSettings});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CallbackBasic {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    initialState: ").append(this.toIndentedString((Object)this.initialState)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    segments: ").append(this.toIndentedString(this.segments)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    held: ").append(this.toIndentedString(this.held)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    startHoldTime: ").append(this.toIndentedString(this.startHoldTime)).append("\n");
        sb.append("    dialerPreview: ").append(this.toIndentedString(this.dialerPreview)).append("\n");
        sb.append("    voicemail: ").append(this.toIndentedString(this.voicemail)).append("\n");
        sb.append("    callbackNumbers: ").append(this.toIndentedString(this.callbackNumbers)).append("\n");
        sb.append("    callbackUserName: ").append(this.toIndentedString(this.callbackUserName)).append("\n");
        sb.append("    scriptId: ").append(this.toIndentedString(this.scriptId)).append("\n");
        sb.append("    externalCampaign: ").append(this.toIndentedString(this.externalCampaign)).append("\n");
        sb.append("    skipEnabled: ").append(this.toIndentedString(this.skipEnabled)).append("\n");
        sb.append("    timeoutSeconds: ").append(this.toIndentedString(this.timeoutSeconds)).append("\n");
        sb.append("    startAlertingTime: ").append(this.toIndentedString(this.startAlertingTime)).append("\n");
        sb.append("    connectedTime: ").append(this.toIndentedString(this.connectedTime)).append("\n");
        sb.append("    disconnectedTime: ").append(this.toIndentedString(this.disconnectedTime)).append("\n");
        sb.append("    callbackScheduledTime: ").append(this.toIndentedString(this.callbackScheduledTime)).append("\n");
        sb.append("    automatedCallbackConfigId: ").append(this.toIndentedString(this.automatedCallbackConfigId)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    peerId: ").append(this.toIndentedString(this.peerId)).append("\n");
        sb.append("    wrapup: ").append(this.toIndentedString(this.wrapup)).append("\n");
        sb.append("    afterCallWork: ").append(this.toIndentedString(this.afterCallWork)).append("\n");
        sb.append("    afterCallWorkRequired: ").append(this.toIndentedString(this.afterCallWorkRequired)).append("\n");
        sb.append("    callerId: ").append(this.toIndentedString(this.callerId)).append("\n");
        sb.append("    callerIdName: ").append(this.toIndentedString(this.callerIdName)).append("\n");
        sb.append("    queueMediaSettings: ").append(this.toIndentedString(this.queueMediaSettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        SCHEDULED("scheduled"),
        NONE("none");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=InitialStateEnumDeserializer.class)
    public static enum InitialStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        SCHEDULED("scheduled"),
        NONE("none");

        private String value;

        private InitialStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static InitialStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (InitialStateEnum value : InitialStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return InitialStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DisconnectTypeEnumDeserializer.class)
    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENDPOINT("endpoint"),
        CLIENT("client"),
        SYSTEM("system"),
        TIMEOUT("timeout"),
        TRANSFER("transfer"),
        TRANSFER_CONFERENCE("transfer.conference"),
        TRANSFER_CONSULT("transfer.consult"),
        TRANSFER_FORWARD("transfer.forward"),
        TRANSFER_NOANSWER("transfer.noanswer"),
        TRANSFER_NOTAVAILABLE("transfer.notavailable"),
        TRANSPORT_FAILURE("transport.failure"),
        ERROR("error"),
        PEER("peer"),
        OTHER("other"),
        SPAM("spam"),
        UNCALLABLE("uncallable");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DisconnectTypeEnumDeserializer
    extends StdDeserializer<DisconnectTypeEnum> {
        public DisconnectTypeEnumDeserializer() {
            super(DisconnectTypeEnumDeserializer.class);
        }

        public DisconnectTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DisconnectTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class InitialStateEnumDeserializer
    extends StdDeserializer<InitialStateEnum> {
        public InitialStateEnumDeserializer() {
            super(InitialStateEnumDeserializer.class);
        }

        public InitialStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return InitialStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

