/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.IpFilter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Settings that control how tracking data is collected and filtered.")
public class TrackingSettings
implements Serializable {
    private List<String> excludedQueryParameters = null;
    private Boolean shouldKeepUrlFragment = null;
    private List<String> searchQueryParameters = null;
    private List<IpFilter> ipFilters = null;

    public TrackingSettings() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.excludedQueryParameters = new ArrayList<String>();
            this.searchQueryParameters = new ArrayList<String>();
            this.ipFilters = new ArrayList<IpFilter>();
        }
    }

    public TrackingSettings excludedQueryParameters(List<String> excludedQueryParameters) {
        this.excludedQueryParameters = excludedQueryParameters;
        return this;
    }

    @ApiModelProperty(example="null", value="List of parameters to be excluded from the query string.")
    @JsonProperty(value="excludedQueryParameters")
    public List<String> getExcludedQueryParameters() {
        return this.excludedQueryParameters;
    }

    public void setExcludedQueryParameters(List<String> excludedQueryParameters) {
        this.excludedQueryParameters = excludedQueryParameters;
    }

    public TrackingSettings shouldKeepUrlFragment(Boolean shouldKeepUrlFragment) {
        this.shouldKeepUrlFragment = shouldKeepUrlFragment;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not to keep the URL fragment.")
    @JsonProperty(value="shouldKeepUrlFragment")
    public Boolean getShouldKeepUrlFragment() {
        return this.shouldKeepUrlFragment;
    }

    public void setShouldKeepUrlFragment(Boolean shouldKeepUrlFragment) {
        this.shouldKeepUrlFragment = shouldKeepUrlFragment;
    }

    public TrackingSettings searchQueryParameters(List<String> searchQueryParameters) {
        this.searchQueryParameters = searchQueryParameters;
        return this;
    }

    @ApiModelProperty(example="null", value="List of query parameters used for search (e.g. 'query').")
    @JsonProperty(value="searchQueryParameters")
    public List<String> getSearchQueryParameters() {
        return this.searchQueryParameters;
    }

    public void setSearchQueryParameters(List<String> searchQueryParameters) {
        this.searchQueryParameters = searchQueryParameters;
    }

    public TrackingSettings ipFilters(List<IpFilter> ipFilters) {
        this.ipFilters = ipFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="IP address filtering configuration for tracking restrictions.")
    @JsonProperty(value="ipFilters")
    public List<IpFilter> getIpFilters() {
        return this.ipFilters;
    }

    public void setIpFilters(List<IpFilter> ipFilters) {
        this.ipFilters = ipFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackingSettings trackingSettings = (TrackingSettings)o;
        return Objects.equals(this.excludedQueryParameters, trackingSettings.excludedQueryParameters) && Objects.equals(this.shouldKeepUrlFragment, trackingSettings.shouldKeepUrlFragment) && Objects.equals(this.searchQueryParameters, trackingSettings.searchQueryParameters) && Objects.equals(this.ipFilters, trackingSettings.ipFilters);
    }

    public int hashCode() {
        return Objects.hash(this.excludedQueryParameters, this.shouldKeepUrlFragment, this.searchQueryParameters, this.ipFilters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrackingSettings {\n");
        sb.append("    excludedQueryParameters: ").append(this.toIndentedString(this.excludedQueryParameters)).append("\n");
        sb.append("    shouldKeepUrlFragment: ").append(this.toIndentedString(this.shouldKeepUrlFragment)).append("\n");
        sb.append("    searchQueryParameters: ").append(this.toIndentedString(this.searchQueryParameters)).append("\n");
        sb.append("    ipFilters: ").append(this.toIndentedString(this.ipFilters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

