/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DocumentBodyTableCaptionBlock;
import com.mypurecloud.sdk.v2.model.DocumentElementLength;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class DocumentBodyTableProperties
implements Serializable {
    private Float width = null;
    private DocumentElementLength widthWithUnit = null;
    private Float height = null;
    private Float cellSpacing = null;
    private Float cellPadding = null;
    private Float borderWidth = null;
    private AlignmentEnum alignment = null;
    private BorderStyleEnum borderStyle = null;
    private String borderColor = null;
    private String backgroundColor = null;
    private DocumentBodyTableCaptionBlock caption = null;

    public DocumentBodyTableProperties() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public DocumentBodyTableProperties width(Float width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(example="null", value="The width of the table converted to em unit.")
    @JsonProperty(value="width")
    public Float getWidth() {
        return this.width;
    }

    public void setWidth(Float width) {
        this.width = width;
    }

    public DocumentBodyTableProperties widthWithUnit(DocumentElementLength widthWithUnit) {
        this.widthWithUnit = widthWithUnit;
        return this;
    }

    @ApiModelProperty(example="null", value="The width of the table in the specified unit.")
    @JsonProperty(value="widthWithUnit")
    public DocumentElementLength getWidthWithUnit() {
        return this.widthWithUnit;
    }

    public void setWidthWithUnit(DocumentElementLength widthWithUnit) {
        this.widthWithUnit = widthWithUnit;
    }

    public DocumentBodyTableProperties height(Float height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(example="null", value="The height for the table.")
    @JsonProperty(value="height")
    public Float getHeight() {
        return this.height;
    }

    public void setHeight(Float height) {
        this.height = height;
    }

    public DocumentBodyTableProperties cellSpacing(Float cellSpacing) {
        this.cellSpacing = cellSpacing;
        return this;
    }

    @ApiModelProperty(example="null", value="The cell spacing for the table. The valid values in 'em'.")
    @JsonProperty(value="cellSpacing")
    public Float getCellSpacing() {
        return this.cellSpacing;
    }

    public void setCellSpacing(Float cellSpacing) {
        this.cellSpacing = cellSpacing;
    }

    public DocumentBodyTableProperties cellPadding(Float cellPadding) {
        this.cellPadding = cellPadding;
        return this;
    }

    @ApiModelProperty(example="null", value="The cell padding for the table. The valid values in 'em'.")
    @JsonProperty(value="cellPadding")
    public Float getCellPadding() {
        return this.cellPadding;
    }

    public void setCellPadding(Float cellPadding) {
        this.cellPadding = cellPadding;
    }

    public DocumentBodyTableProperties borderWidth(Float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    @ApiModelProperty(example="null", value="The border width for the table. The valid values in 'em'")
    @JsonProperty(value="borderWidth")
    public Float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(Float borderWidth) {
        this.borderWidth = borderWidth;
    }

    public DocumentBodyTableProperties alignment(AlignmentEnum alignment) {
        this.alignment = alignment;
        return this;
    }

    @ApiModelProperty(example="null", value="The alignment for the table.")
    @JsonProperty(value="alignment")
    public AlignmentEnum getAlignment() {
        return this.alignment;
    }

    public void setAlignment(AlignmentEnum alignment) {
        this.alignment = alignment;
    }

    public DocumentBodyTableProperties borderStyle(BorderStyleEnum borderStyle) {
        this.borderStyle = borderStyle;
        return this;
    }

    @ApiModelProperty(example="null", value="The border style for the table.")
    @JsonProperty(value="borderStyle")
    public BorderStyleEnum getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(BorderStyleEnum borderStyle) {
        this.borderStyle = borderStyle;
    }

    public DocumentBodyTableProperties borderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    @ApiModelProperty(example="null", value="The border color for the table. The valid values in hex color code representation. For example black color - #000000")
    @JsonProperty(value="borderColor")
    public String getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }

    public DocumentBodyTableProperties backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @ApiModelProperty(example="null", value="The background color for the table. The valid values in hex color code representation. For example black color - #000000")
    @JsonProperty(value="backgroundColor")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public DocumentBodyTableProperties caption(DocumentBodyTableCaptionBlock caption) {
        this.caption = caption;
        return this;
    }

    @ApiModelProperty(example="null", value="The caption for the table. The valid values in hex color code representation. For example black color - #000000")
    @JsonProperty(value="caption")
    public DocumentBodyTableCaptionBlock getCaption() {
        return this.caption;
    }

    public void setCaption(DocumentBodyTableCaptionBlock caption) {
        this.caption = caption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentBodyTableProperties documentBodyTableProperties = (DocumentBodyTableProperties)o;
        return Objects.equals(this.width, documentBodyTableProperties.width) && Objects.equals(this.widthWithUnit, documentBodyTableProperties.widthWithUnit) && Objects.equals(this.height, documentBodyTableProperties.height) && Objects.equals(this.cellSpacing, documentBodyTableProperties.cellSpacing) && Objects.equals(this.cellPadding, documentBodyTableProperties.cellPadding) && Objects.equals(this.borderWidth, documentBodyTableProperties.borderWidth) && Objects.equals((Object)this.alignment, (Object)documentBodyTableProperties.alignment) && Objects.equals((Object)this.borderStyle, (Object)documentBodyTableProperties.borderStyle) && Objects.equals(this.borderColor, documentBodyTableProperties.borderColor) && Objects.equals(this.backgroundColor, documentBodyTableProperties.backgroundColor) && Objects.equals(this.caption, documentBodyTableProperties.caption);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.width, this.widthWithUnit, this.height, this.cellSpacing, this.cellPadding, this.borderWidth, this.alignment, this.borderStyle, this.borderColor, this.backgroundColor, this.caption});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentBodyTableProperties {\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    widthWithUnit: ").append(this.toIndentedString(this.widthWithUnit)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    cellSpacing: ").append(this.toIndentedString(this.cellSpacing)).append("\n");
        sb.append("    cellPadding: ").append(this.toIndentedString(this.cellPadding)).append("\n");
        sb.append("    borderWidth: ").append(this.toIndentedString(this.borderWidth)).append("\n");
        sb.append("    alignment: ").append(this.toIndentedString((Object)this.alignment)).append("\n");
        sb.append("    borderStyle: ").append(this.toIndentedString((Object)this.borderStyle)).append("\n");
        sb.append("    borderColor: ").append(this.toIndentedString(this.borderColor)).append("\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    caption: ").append(this.toIndentedString(this.caption)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AlignmentEnumDeserializer.class)
    public static enum AlignmentEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CENTER("Center"),
        LEFT("Left"),
        RIGHT("Right");

        private String value;

        private AlignmentEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AlignmentEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AlignmentEnum value : AlignmentEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AlignmentEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=BorderStyleEnumDeserializer.class)
    public static enum BorderStyleEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SOLID("Solid"),
        DOTTED("Dotted"),
        DASHED("Dashed"),
        DOUBLE("Double"),
        GROOVE("Groove"),
        RIDGE("Ridge"),
        INSET("Inset"),
        OUTSET("Outset"),
        HIDDEN("Hidden"),
        NONE("None");

        private String value;

        private BorderStyleEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static BorderStyleEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (BorderStyleEnum value : BorderStyleEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return BorderStyleEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class BorderStyleEnumDeserializer
    extends StdDeserializer<BorderStyleEnum> {
        public BorderStyleEnumDeserializer() {
            super(BorderStyleEnumDeserializer.class);
        }

        public BorderStyleEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return BorderStyleEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class AlignmentEnumDeserializer
    extends StdDeserializer<AlignmentEnum> {
        public AlignmentEnumDeserializer() {
            super(AlignmentEnumDeserializer.class);
        }

        public AlignmentEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AlignmentEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

