/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.AsyncApiCallback;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetAssistantCopilotRequest;
import com.mypurecloud.sdk.v2.api.request.GetAssistantsCopilotFeaturesupportRequest;
import com.mypurecloud.sdk.v2.api.request.PutAssistantCopilotRequest;
import com.mypurecloud.sdk.v2.model.Copilot;
import com.mypurecloud.sdk.v2.model.LanguageSupportResponse;
import java.util.concurrent.Future;

public class AgentCopilotApiAsync {
    private final ApiClient pcapiClient;

    public AgentCopilotApiAsync() {
        this(Configuration.getDefaultApiClient());
    }

    public AgentCopilotApiAsync(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public Future<Copilot> getAssistantCopilotAsync(GetAssistantCopilotRequest request, final AsyncApiCallback<Copilot> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<Copilot>(){}, new AsyncApiCallback<ApiResponse<Copilot>>(){

                @Override
                public void onCompleted(ApiResponse<Copilot> response) {
                    AgentCopilotApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        AgentCopilotApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        AgentCopilotApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<Copilot>> getAssistantCopilotAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<Copilot>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<Copilot>(){}, new AsyncApiCallback<ApiResponse<Copilot>>(){

                @Override
                public void onCompleted(ApiResponse<Copilot> response) {
                    AgentCopilotApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        AgentCopilotApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        AgentCopilotApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        AgentCopilotApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<LanguageSupportResponse> getAssistantsCopilotFeaturesupportAsync(GetAssistantsCopilotFeaturesupportRequest request, final AsyncApiCallback<LanguageSupportResponse> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<LanguageSupportResponse>(){}, new AsyncApiCallback<ApiResponse<LanguageSupportResponse>>(){

                @Override
                public void onCompleted(ApiResponse<LanguageSupportResponse> response) {
                    AgentCopilotApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        AgentCopilotApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        AgentCopilotApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<LanguageSupportResponse>> getAssistantsCopilotFeaturesupportAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<LanguageSupportResponse>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<LanguageSupportResponse>(){}, new AsyncApiCallback<ApiResponse<LanguageSupportResponse>>(){

                @Override
                public void onCompleted(ApiResponse<LanguageSupportResponse> response) {
                    AgentCopilotApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        AgentCopilotApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        AgentCopilotApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        AgentCopilotApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<Copilot> putAssistantCopilotAsync(PutAssistantCopilotRequest request, final AsyncApiCallback<Copilot> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<Copilot>(){}, new AsyncApiCallback<ApiResponse<Copilot>>(){

                @Override
                public void onCompleted(ApiResponse<Copilot> response) {
                    AgentCopilotApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        AgentCopilotApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        AgentCopilotApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<Copilot>> putAssistantCopilotAsync(ApiRequest<Copilot> request, final AsyncApiCallback<ApiResponse<Copilot>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<Copilot>(){}, new AsyncApiCallback<ApiResponse<Copilot>>(){

                @Override
                public void onCompleted(ApiResponse<Copilot> response) {
                    AgentCopilotApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        AgentCopilotApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        AgentCopilotApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        AgentCopilotApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    private <T> void notifySuccess(SettableFuture<T> future, AsyncApiCallback<T> callback, T result) {
        if (callback != null) {
            try {
                callback.onCompleted(result);
                future.set(result);
            }
            catch (Throwable exception) {
                future.setException(exception);
            }
        } else {
            future.set(result);
        }
    }

    private <T> void notifyFailure(SettableFuture<T> future, AsyncApiCallback<T> callback, Throwable exception) {
        if (callback != null) {
            try {
                callback.onFailed(exception);
                future.setException(exception);
            }
            catch (Throwable callbackException) {
                future.setException(callbackException);
            }
        } else {
            future.setException(exception);
        }
    }
}

