/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Represents an organization language assigned to a user. When assigning to a user specify the organization langauge id as the id.")
public class UserRoutingLanguagePost
implements Serializable {
    private String id = null;
    private Double proficiency = null;
    private String languageUri = null;
    private String selfUri = null;

    public UserRoutingLanguagePost() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public UserRoutingLanguagePost id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id of the existing routing language to add to the user")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UserRoutingLanguagePost proficiency(Double proficiency) {
        this.proficiency = proficiency;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Proficiency is a rating from 0.0 to 5.0 on how competent an agent is for a particular language. It is used when a queue is set to \"Best available language\" mode to allow acd interactions to target agents with higher proficiency ratings.")
    @JsonProperty(value="proficiency")
    public Double getProficiency() {
        return this.proficiency;
    }

    public void setProficiency(Double proficiency) {
        this.proficiency = proficiency;
    }

    @ApiModelProperty(example="null", value="URI to the organization language used by this user language.")
    @JsonProperty(value="languageUri")
    public String getLanguageUri() {
        return this.languageUri;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserRoutingLanguagePost userRoutingLanguagePost = (UserRoutingLanguagePost)o;
        return Objects.equals(this.id, userRoutingLanguagePost.id) && Objects.equals(this.proficiency, userRoutingLanguagePost.proficiency) && Objects.equals(this.languageUri, userRoutingLanguagePost.languageUri) && Objects.equals(this.selfUri, userRoutingLanguagePost.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.proficiency, this.languageUri, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserRoutingLanguagePost {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    proficiency: ").append(this.toIndentedString(this.proficiency)).append("\n");
        sb.append("    languageUri: ").append(this.toIndentedString(this.languageUri)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

