/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class ServiceLevel
implements Serializable {
    private Double percentage = null;
    private Long durationMs = null;

    public ServiceLevel() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ServiceLevel percentage(Double percentage) {
        this.percentage = percentage;
        return this;
    }

    @ApiModelProperty(example="null", value="The desired Service Level. A value between 0 and 1.")
    @JsonProperty(value="percentage")
    public Double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(Double percentage) {
        this.percentage = percentage;
    }

    public ServiceLevel durationMs(Long durationMs) {
        this.durationMs = durationMs;
        return this;
    }

    @ApiModelProperty(example="null", value="Service Level target in milliseconds.")
    @JsonProperty(value="durationMs")
    public Long getDurationMs() {
        return this.durationMs;
    }

    public void setDurationMs(Long durationMs) {
        this.durationMs = durationMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLevel serviceLevel = (ServiceLevel)o;
        return Objects.equals(this.percentage, serviceLevel.percentage) && Objects.equals(this.durationMs, serviceLevel.durationMs);
    }

    public int hashCode() {
        return Objects.hash(this.percentage, this.durationMs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceLevel {\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("    durationMs: ").append(this.toIndentedString(this.durationMs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

