/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ReprocessJobResponse
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private Date dateStart = null;
    private Date dateEnd = null;
    private List<MediaTypesEnum> mediaTypes = null;
    private List<String> programs = null;
    private List<String> dialects = null;
    private AddressableEntityRef createdBy = null;
    private Date dateCreated = null;
    private JobStatusEnum jobStatus = null;
    private Integer queueOrder = null;
    private Integer processedInteractionsCount = null;
    private Integer failedInteractionsCount = null;
    private Integer totalInteractionsCount = null;
    private String selfUri = null;

    public ReprocessJobResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.mediaTypes = new ArrayList<MediaTypesEnum>();
            this.programs = new ArrayList<String>();
            this.dialects = new ArrayList<String>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ReprocessJobResponse name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReprocessJobResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the job.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ReprocessJobResponse dateStart(Date dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The date from which the reprocessing should begin. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStart")
    public Date getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(Date dateStart) {
        this.dateStart = dateStart;
    }

    public ReprocessJobResponse dateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The date at which the reprocessing should end. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateEnd")
    public Date getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
    }

    public ReprocessJobResponse mediaTypes(List<MediaTypesEnum> mediaTypes) {
        this.mediaTypes = mediaTypes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Media types used to filter interactions.")
    @JsonProperty(value="mediaTypes")
    public List<MediaTypesEnum> getMediaTypes() {
        return this.mediaTypes;
    }

    public void setMediaTypes(List<MediaTypesEnum> mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public ReprocessJobResponse programs(List<String> programs) {
        this.programs = programs;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The mapped programs to be included in the job.")
    @JsonProperty(value="programs")
    public List<String> getPrograms() {
        return this.programs;
    }

    public void setPrograms(List<String> programs) {
        this.programs = programs;
    }

    public ReprocessJobResponse dialects(List<String> dialects) {
        this.dialects = dialects;
        return this;
    }

    @ApiModelProperty(example="null", value="Language dialects used to filter interactions.")
    @JsonProperty(value="dialects")
    public List<String> getDialects() {
        return this.dialects;
    }

    public void setDialects(List<String> dialects) {
        this.dialects = dialects;
    }

    public ReprocessJobResponse createdBy(AddressableEntityRef createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user who created the job.")
    @JsonProperty(value="createdBy")
    public AddressableEntityRef getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(AddressableEntityRef createdBy) {
        this.createdBy = createdBy;
    }

    public ReprocessJobResponse dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The date the job was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public ReprocessJobResponse jobStatus(JobStatusEnum jobStatus) {
        this.jobStatus = jobStatus;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The status of the job.")
    @JsonProperty(value="jobStatus")
    public JobStatusEnum getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(JobStatusEnum jobStatus) {
        this.jobStatus = jobStatus;
    }

    public ReprocessJobResponse queueOrder(Integer queueOrder) {
        this.queueOrder = queueOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="The position of the job in the queued jobs.")
    @JsonProperty(value="queueOrder")
    public Integer getQueueOrder() {
        return this.queueOrder;
    }

    public void setQueueOrder(Integer queueOrder) {
        this.queueOrder = queueOrder;
    }

    public ReprocessJobResponse processedInteractionsCount(Integer processedInteractionsCount) {
        this.processedInteractionsCount = processedInteractionsCount;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The amount of interactions successfully reprocessed.")
    @JsonProperty(value="processedInteractionsCount")
    public Integer getProcessedInteractionsCount() {
        return this.processedInteractionsCount;
    }

    public void setProcessedInteractionsCount(Integer processedInteractionsCount) {
        this.processedInteractionsCount = processedInteractionsCount;
    }

    public ReprocessJobResponse failedInteractionsCount(Integer failedInteractionsCount) {
        this.failedInteractionsCount = failedInteractionsCount;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The amount of failed interactions.")
    @JsonProperty(value="failedInteractionsCount")
    public Integer getFailedInteractionsCount() {
        return this.failedInteractionsCount;
    }

    public void setFailedInteractionsCount(Integer failedInteractionsCount) {
        this.failedInteractionsCount = failedInteractionsCount;
    }

    public ReprocessJobResponse totalInteractionsCount(Integer totalInteractionsCount) {
        this.totalInteractionsCount = totalInteractionsCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount of interactions in the job.")
    @JsonProperty(value="totalInteractionsCount")
    public Integer getTotalInteractionsCount() {
        return this.totalInteractionsCount;
    }

    public void setTotalInteractionsCount(Integer totalInteractionsCount) {
        this.totalInteractionsCount = totalInteractionsCount;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReprocessJobResponse reprocessJobResponse = (ReprocessJobResponse)o;
        return Objects.equals(this.id, reprocessJobResponse.id) && Objects.equals(this.name, reprocessJobResponse.name) && Objects.equals(this.description, reprocessJobResponse.description) && Objects.equals(this.dateStart, reprocessJobResponse.dateStart) && Objects.equals(this.dateEnd, reprocessJobResponse.dateEnd) && Objects.equals(this.mediaTypes, reprocessJobResponse.mediaTypes) && Objects.equals(this.programs, reprocessJobResponse.programs) && Objects.equals(this.dialects, reprocessJobResponse.dialects) && Objects.equals(this.createdBy, reprocessJobResponse.createdBy) && Objects.equals(this.dateCreated, reprocessJobResponse.dateCreated) && Objects.equals((Object)this.jobStatus, (Object)reprocessJobResponse.jobStatus) && Objects.equals(this.queueOrder, reprocessJobResponse.queueOrder) && Objects.equals(this.processedInteractionsCount, reprocessJobResponse.processedInteractionsCount) && Objects.equals(this.failedInteractionsCount, reprocessJobResponse.failedInteractionsCount) && Objects.equals(this.totalInteractionsCount, reprocessJobResponse.totalInteractionsCount) && Objects.equals(this.selfUri, reprocessJobResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.dateStart, this.dateEnd, this.mediaTypes, this.programs, this.dialects, this.createdBy, this.dateCreated, this.jobStatus, this.queueOrder, this.processedInteractionsCount, this.failedInteractionsCount, this.totalInteractionsCount, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReprocessJobResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    dateEnd: ").append(this.toIndentedString(this.dateEnd)).append("\n");
        sb.append("    mediaTypes: ").append(this.toIndentedString(this.mediaTypes)).append("\n");
        sb.append("    programs: ").append(this.toIndentedString(this.programs)).append("\n");
        sb.append("    dialects: ").append(this.toIndentedString(this.dialects)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    jobStatus: ").append(this.toIndentedString((Object)this.jobStatus)).append("\n");
        sb.append("    queueOrder: ").append(this.toIndentedString(this.queueOrder)).append("\n");
        sb.append("    processedInteractionsCount: ").append(this.toIndentedString(this.processedInteractionsCount)).append("\n");
        sb.append("    failedInteractionsCount: ").append(this.toIndentedString(this.failedInteractionsCount)).append("\n");
        sb.append("    totalInteractionsCount: ").append(this.toIndentedString(this.totalInteractionsCount)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=JobStatusEnumDeserializer.class)
    public static enum JobStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUEUED("Queued"),
        INPROGRESS("InProgress"),
        COMPLETED("Completed"),
        FAILED("Failed");

        private String value;

        private JobStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static JobStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (JobStatusEnum value : JobStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return JobStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class JobStatusEnumDeserializer
    extends StdDeserializer<JobStatusEnum> {
        public JobStatusEnumDeserializer() {
            super(JobStatusEnumDeserializer.class);
        }

        public JobStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return JobStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=MediaTypesEnumDeserializer.class)
    public static enum MediaTypesEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CALL("Call"),
        CALLBACK("Callback"),
        CHAT("Chat"),
        EMAIL("Email"),
        MESSAGE("Message");

        private String value;

        private MediaTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypesEnum value : MediaTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypesEnumDeserializer
    extends StdDeserializer<MediaTypesEnum> {
        public MediaTypesEnumDeserializer() {
            super(MediaTypesEnumDeserializer.class);
        }

        public MediaTypesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypesEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

