/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DocumentChunkBlock;
import com.mypurecloud.sdk.v2.model.KnowledgeConversationContextResponse;
import com.mypurecloud.sdk.v2.model.KnowledgeSearchClientApplication;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class KnowledgeDocumentChunkResponse
implements Serializable {
    private String query = null;
    private Integer total = null;
    private Integer pageCount = null;
    private Integer pageSize = null;
    private Integer pageNumber = null;
    private QueryTypeEnum queryType = null;
    private String searchId = null;
    private Boolean preprocessQuery = null;
    private Float confidenceThreshold = null;
    private List<DocumentChunkBlock> results = null;
    private KnowledgeSearchClientApplication application = null;
    private KnowledgeConversationContextResponse conversationContext = null;

    public KnowledgeDocumentChunkResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.results = new ArrayList<DocumentChunkBlock>();
        }
    }

    public KnowledgeDocumentChunkResponse query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="null", value="Query to search chunks in the knowledge base.")
    @JsonProperty(value="query")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @ApiModelProperty(example="null", value="The total number of chunks matching the query.")
    @JsonProperty(value="total")
    public Integer getTotal() {
        return this.total;
    }

    @ApiModelProperty(example="null", value="Number of pages returned in the result calculated according to the pageSize and the total")
    @JsonProperty(value="pageCount")
    public Integer getPageCount() {
        return this.pageCount;
    }

    public KnowledgeDocumentChunkResponse pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="Page size of the returned results.")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public KnowledgeDocumentChunkResponse pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Page number of the returned results.")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public KnowledgeDocumentChunkResponse queryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the query that initiates the chunks search.")
    @JsonProperty(value="queryType")
    public QueryTypeEnum getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the chunks search.")
    @JsonProperty(value="searchId")
    public String getSearchId() {
        return this.searchId;
    }

    public KnowledgeDocumentChunkResponse preprocessQuery(Boolean preprocessQuery) {
        this.preprocessQuery = preprocessQuery;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether the chunks search query should be preprocessed.")
    @JsonProperty(value="preprocessQuery")
    public Boolean getPreprocessQuery() {
        return this.preprocessQuery;
    }

    public void setPreprocessQuery(Boolean preprocessQuery) {
        this.preprocessQuery = preprocessQuery;
    }

    public KnowledgeDocumentChunkResponse confidenceThreshold(Float confidenceThreshold) {
        this.confidenceThreshold = confidenceThreshold;
        return this;
    }

    @ApiModelProperty(example="null", value="The confidence threshold for the chunk results. If applied, the returned results will have an equal or higher chunk confidence than the threshold.")
    @JsonProperty(value="confidenceThreshold")
    public Float getConfidenceThreshold() {
        return this.confidenceThreshold;
    }

    public void setConfidenceThreshold(Float confidenceThreshold) {
        this.confidenceThreshold = confidenceThreshold;
    }

    public KnowledgeDocumentChunkResponse results(List<DocumentChunkBlock> results) {
        this.results = results;
        return this;
    }

    @ApiModelProperty(example="null", value="Chunks matching the search query.")
    @JsonProperty(value="results")
    public List<DocumentChunkBlock> getResults() {
        return this.results;
    }

    public void setResults(List<DocumentChunkBlock> results) {
        this.results = results;
    }

    public KnowledgeDocumentChunkResponse application(KnowledgeSearchClientApplication application) {
        this.application = application;
        return this;
    }

    @ApiModelProperty(example="null", value="The client application details from which chunks search happened.")
    @JsonProperty(value="application")
    public KnowledgeSearchClientApplication getApplication() {
        return this.application;
    }

    public void setApplication(KnowledgeSearchClientApplication application) {
        this.application = application;
    }

    public KnowledgeDocumentChunkResponse conversationContext(KnowledgeConversationContextResponse conversationContext) {
        this.conversationContext = conversationContext;
        return this;
    }

    @ApiModelProperty(example="null", value="Conversation context information if the chunks search is initiated in the context of a conversation.")
    @JsonProperty(value="conversationContext")
    public KnowledgeConversationContextResponse getConversationContext() {
        return this.conversationContext;
    }

    public void setConversationContext(KnowledgeConversationContextResponse conversationContext) {
        this.conversationContext = conversationContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeDocumentChunkResponse knowledgeDocumentChunkResponse = (KnowledgeDocumentChunkResponse)o;
        return Objects.equals(this.query, knowledgeDocumentChunkResponse.query) && Objects.equals(this.total, knowledgeDocumentChunkResponse.total) && Objects.equals(this.pageCount, knowledgeDocumentChunkResponse.pageCount) && Objects.equals(this.pageSize, knowledgeDocumentChunkResponse.pageSize) && Objects.equals(this.pageNumber, knowledgeDocumentChunkResponse.pageNumber) && Objects.equals((Object)this.queryType, (Object)knowledgeDocumentChunkResponse.queryType) && Objects.equals(this.searchId, knowledgeDocumentChunkResponse.searchId) && Objects.equals(this.preprocessQuery, knowledgeDocumentChunkResponse.preprocessQuery) && Objects.equals(this.confidenceThreshold, knowledgeDocumentChunkResponse.confidenceThreshold) && Objects.equals(this.results, knowledgeDocumentChunkResponse.results) && Objects.equals(this.application, knowledgeDocumentChunkResponse.application) && Objects.equals(this.conversationContext, knowledgeDocumentChunkResponse.conversationContext);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.total, this.pageCount, this.pageSize, this.pageNumber, this.queryType, this.searchId, this.preprocessQuery, this.confidenceThreshold, this.results, this.application, this.conversationContext});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeDocumentChunkResponse {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.pageCount)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    queryType: ").append(this.toIndentedString((Object)this.queryType)).append("\n");
        sb.append("    searchId: ").append(this.toIndentedString(this.searchId)).append("\n");
        sb.append("    preprocessQuery: ").append(this.toIndentedString(this.preprocessQuery)).append("\n");
        sb.append("    confidenceThreshold: ").append(this.toIndentedString(this.confidenceThreshold)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("    conversationContext: ").append(this.toIndentedString(this.conversationContext)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=QueryTypeEnumDeserializer.class)
    public static enum QueryTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AUTOSEARCH("AutoSearch"),
        MANUALSEARCH("ManualSearch"),
        SUGGESTION("Suggestion");

        private String value;

        private QueryTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static QueryTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (QueryTypeEnum value : QueryTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return QueryTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class QueryTypeEnumDeserializer
    extends StdDeserializer<QueryTypeEnum> {
        public QueryTypeEnumDeserializer() {
            super(QueryTypeEnumDeserializer.class);
        }

        public QueryTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return QueryTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

