/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Request body for generating the content of a guide")
public class GenerateGuideContentRequest
implements Serializable {
    private String description = null;
    private String url = null;

    public GenerateGuideContentRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public GenerateGuideContentRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Generate a guide to help a Customer return a product.", value="The description that you wish to use to generate the guide content from.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GenerateGuideContentRequest url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="https://fileupload.genesys.com/orgs/123/456.1001847777_1001848412_a33bc09383e53314a3be61ca.sasf?X-Amz-Algorithm&#x3D;AWS4-HMAC-SHA256", value="The URL of the file you wish to use to generate the guide content from.")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenerateGuideContentRequest generateGuideContentRequest = (GenerateGuideContentRequest)o;
        return Objects.equals(this.description, generateGuideContentRequest.description) && Objects.equals(this.url, generateGuideContentRequest.url);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GenerateGuideContentRequest {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

