/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class FeatureSupport
implements Serializable {
    private String feature = null;
    private SupportLevelEnum supportLevel = null;
    private String details = null;

    public FeatureSupport() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="Feature name.")
    @JsonProperty(value="feature")
    public String getFeature() {
        return this.feature;
    }

    @ApiModelProperty(example="null", value="Level of support for a feature.")
    @JsonProperty(value="supportLevel")
    public SupportLevelEnum getSupportLevel() {
        return this.supportLevel;
    }

    @ApiModelProperty(example="null", value="Additional information for the support of a feature.")
    @JsonProperty(value="details")
    public String getDetails() {
        return this.details;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureSupport featureSupport = (FeatureSupport)o;
        return Objects.equals(this.feature, featureSupport.feature) && Objects.equals((Object)this.supportLevel, (Object)featureSupport.supportLevel) && Objects.equals(this.details, featureSupport.details);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feature, this.supportLevel, this.details});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureSupport {\n");
        sb.append("    feature: ").append(this.toIndentedString(this.feature)).append("\n");
        sb.append("    supportLevel: ").append(this.toIndentedString((Object)this.supportLevel)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SupportLevelEnumDeserializer.class)
    public static enum SupportLevelEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SUPPORTED("Supported"),
        NOTSUPPORTED("NotSupported");

        private String value;

        private SupportLevelEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SupportLevelEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SupportLevelEnum value : SupportLevelEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SupportLevelEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SupportLevelEnumDeserializer
    extends StdDeserializer<SupportLevelEnum> {
        public SupportLevelEnumDeserializer() {
            super(SupportLevelEnumDeserializer.class);
        }

        public SupportLevelEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SupportLevelEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

