/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DocumentBodyImage;
import com.mypurecloud.sdk.v2.model.DocumentBodyList;
import com.mypurecloud.sdk.v2.model.DocumentBodyParagraph;
import com.mypurecloud.sdk.v2.model.DocumentBodyTable;
import com.mypurecloud.sdk.v2.model.DocumentBodyVideo;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class DocumentBodyBlock
implements Serializable {
    private TypeEnum type = null;
    private DocumentBodyImage image = null;
    private DocumentBodyVideo video = null;
    private DocumentBodyParagraph paragraph = null;
    private DocumentBodyList list = null;
    private DocumentBodyTable table = null;

    public DocumentBodyBlock() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public DocumentBodyBlock type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of the block for the body. This determines which body block object (paragraph, list, video, image or table) would have a value.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public DocumentBodyBlock image(DocumentBodyImage image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(example="null", value="Image. It must contain a value if the type of the block is Image.")
    @JsonProperty(value="image")
    public DocumentBodyImage getImage() {
        return this.image;
    }

    public void setImage(DocumentBodyImage image) {
        this.image = image;
    }

    public DocumentBodyBlock video(DocumentBodyVideo video) {
        this.video = video;
        return this;
    }

    @ApiModelProperty(example="null", value="Video. It must contain a value if the type of the block is Video.")
    @JsonProperty(value="video")
    public DocumentBodyVideo getVideo() {
        return this.video;
    }

    public void setVideo(DocumentBodyVideo video) {
        this.video = video;
    }

    public DocumentBodyBlock paragraph(DocumentBodyParagraph paragraph) {
        this.paragraph = paragraph;
        return this;
    }

    @ApiModelProperty(example="null", value="Paragraph. It must contain a value if the type of the block is Paragraph.")
    @JsonProperty(value="paragraph")
    public DocumentBodyParagraph getParagraph() {
        return this.paragraph;
    }

    public void setParagraph(DocumentBodyParagraph paragraph) {
        this.paragraph = paragraph;
    }

    public DocumentBodyBlock list(DocumentBodyList list) {
        this.list = list;
        return this;
    }

    @ApiModelProperty(example="null", value="List. It must contain a value if the type of the block is UnorderedList or OrderedList.")
    @JsonProperty(value="list")
    public DocumentBodyList getList() {
        return this.list;
    }

    public void setList(DocumentBodyList list) {
        this.list = list;
    }

    public DocumentBodyBlock table(DocumentBodyTable table) {
        this.table = table;
        return this;
    }

    @ApiModelProperty(example="null", value="Table. It must contain a value if type of the block is Table.")
    @JsonProperty(value="table")
    public DocumentBodyTable getTable() {
        return this.table;
    }

    public void setTable(DocumentBodyTable table) {
        this.table = table;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentBodyBlock documentBodyBlock = (DocumentBodyBlock)o;
        return Objects.equals((Object)this.type, (Object)documentBodyBlock.type) && Objects.equals(this.image, documentBodyBlock.image) && Objects.equals(this.video, documentBodyBlock.video) && Objects.equals(this.paragraph, documentBodyBlock.paragraph) && Objects.equals(this.list, documentBodyBlock.list) && Objects.equals(this.table, documentBodyBlock.table);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.image, this.video, this.paragraph, this.list, this.table});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentBodyBlock {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    video: ").append(this.toIndentedString(this.video)).append("\n");
        sb.append("    paragraph: ").append(this.toIndentedString(this.paragraph)).append("\n");
        sb.append("    list: ").append(this.toIndentedString(this.list)).append("\n");
        sb.append("    table: ").append(this.toIndentedString(this.table)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PARAGRAPH("Paragraph"),
        IMAGE("Image"),
        VIDEO("Video"),
        ORDEREDLIST("OrderedList"),
        UNORDEREDLIST("UnorderedList"),
        TABLE("Table");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

