/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.UserObservationQueryFilter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UserObservationQuery
implements Serializable {
    private UserObservationQueryFilter filter = null;
    private List<MetricsEnum> metrics = null;
    private List<DetailMetricsEnum> detailMetrics = null;

    public UserObservationQuery() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.metrics = new ArrayList<MetricsEnum>();
            this.detailMetrics = new ArrayList<DetailMetricsEnum>();
        }
    }

    public UserObservationQuery filter(UserObservationQueryFilter filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Filter to return a subset of observations. Expresses boolean logical predicates as well as dimensional filters")
    @JsonProperty(value="filter")
    public UserObservationQueryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(UserObservationQueryFilter filter) {
        this.filter = filter;
    }

    public UserObservationQuery metrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Behaves like a SQL SELECT clause. Only named metrics will be retrieved.")
    @JsonProperty(value="metrics")
    public List<MetricsEnum> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
    }

    public UserObservationQuery detailMetrics(List<DetailMetricsEnum> detailMetrics) {
        this.detailMetrics = detailMetrics;
        return this;
    }

    @ApiModelProperty(example="null", value="Metrics for which to include additional detailed observations")
    @JsonProperty(value="detailMetrics")
    public List<DetailMetricsEnum> getDetailMetrics() {
        return this.detailMetrics;
    }

    public void setDetailMetrics(List<DetailMetricsEnum> detailMetrics) {
        this.detailMetrics = detailMetrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserObservationQuery userObservationQuery = (UserObservationQuery)o;
        return Objects.equals(this.filter, userObservationQuery.filter) && Objects.equals(this.metrics, userObservationQuery.metrics) && Objects.equals(this.detailMetrics, userObservationQuery.detailMetrics);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.metrics, this.detailMetrics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserObservationQuery {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    detailMetrics: ").append(this.toIndentedString(this.detailMetrics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DetailMetricsEnumDeserializer.class)
    public static enum DetailMetricsEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OACTIVEQUEUES("oActiveQueues"),
        OMEMBERQUEUES("oMemberQueues");

        private String value;

        private DetailMetricsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DetailMetricsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DetailMetricsEnum value : DetailMetricsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DetailMetricsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DetailMetricsEnumDeserializer
    extends StdDeserializer<DetailMetricsEnum> {
        public DetailMetricsEnumDeserializer() {
            super(DetailMetricsEnumDeserializer.class);
        }

        public DetailMetricsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DetailMetricsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=MetricsEnumDeserializer.class)
    public static enum MetricsEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OACTIVEQUEUES("oActiveQueues"),
        OMEMBERQUEUES("oMemberQueues");

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricsEnum value : MetricsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MetricsEnumDeserializer
    extends StdDeserializer<MetricsEnum> {
        public MetricsEnumDeserializer() {
            super(MetricsEnumDeserializer.class);
        }

        public MetricsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricsEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

