/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.BusinessUnitReference;
import com.mypurecloud.sdk.v2.model.ManagementUnitReference;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class AdherenceExplanationResponse
implements Serializable {
    private String id = null;
    private UserReference agent = null;
    private ManagementUnitReference managementUnit = null;
    private BusinessUnitReference businessUnit = null;
    private TypeEnum type = null;
    private StatusEnum status = null;
    private Date startDate = null;
    private Integer lengthMinutes = null;
    private String notes = null;
    private UserReference reviewedBy = null;
    private Date reviewedDate = null;
    private String selfUri = null;

    public AdherenceExplanationResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public AdherenceExplanationResponse agent(UserReference agent) {
        this.agent = agent;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The agent to whom this adherence explanation applies")
    @JsonProperty(value="agent")
    public UserReference getAgent() {
        return this.agent;
    }

    public void setAgent(UserReference agent) {
        this.agent = agent;
    }

    public AdherenceExplanationResponse managementUnit(ManagementUnitReference managementUnit) {
        this.managementUnit = managementUnit;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The management unit to which the agent belonged at the time the adherence explanation was submitted")
    @JsonProperty(value="managementUnit")
    public ManagementUnitReference getManagementUnit() {
        return this.managementUnit;
    }

    public void setManagementUnit(ManagementUnitReference managementUnit) {
        this.managementUnit = managementUnit;
    }

    public AdherenceExplanationResponse businessUnit(BusinessUnitReference businessUnit) {
        this.businessUnit = businessUnit;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The business unit to which the agent belonged at the time the adherence explanation was submitted")
    @JsonProperty(value="businessUnit")
    public BusinessUnitReference getBusinessUnit() {
        return this.businessUnit;
    }

    public void setBusinessUnit(BusinessUnitReference businessUnit) {
        this.businessUnit = businessUnit;
    }

    public AdherenceExplanationResponse type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of the adherence explanation")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public AdherenceExplanationResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The status of the adherence explanation")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AdherenceExplanationResponse startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The start timestamp of the adherence explanation in ISO-8601 format")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public AdherenceExplanationResponse lengthMinutes(Integer lengthMinutes) {
        this.lengthMinutes = lengthMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The length of the adherence explanation in minutes")
    @JsonProperty(value="lengthMinutes")
    public Integer getLengthMinutes() {
        return this.lengthMinutes;
    }

    public void setLengthMinutes(Integer lengthMinutes) {
        this.lengthMinutes = lengthMinutes;
    }

    public AdherenceExplanationResponse notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(example="null", value="Notes about the adherence explanation")
    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public AdherenceExplanationResponse reviewedBy(UserReference reviewedBy) {
        this.reviewedBy = reviewedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who reviewed the adherence explanation, if applicable. The id may be 'System' if it was an automated process")
    @JsonProperty(value="reviewedBy")
    public UserReference getReviewedBy() {
        return this.reviewedBy;
    }

    public void setReviewedBy(UserReference reviewedBy) {
        this.reviewedBy = reviewedBy;
    }

    public AdherenceExplanationResponse reviewedDate(Date reviewedDate) {
        this.reviewedDate = reviewedDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp for when the adherence explanation was reviewed, if applicable. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="reviewedDate")
    public Date getReviewedDate() {
        return this.reviewedDate;
    }

    public void setReviewedDate(Date reviewedDate) {
        this.reviewedDate = reviewedDate;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdherenceExplanationResponse adherenceExplanationResponse = (AdherenceExplanationResponse)o;
        return Objects.equals(this.id, adherenceExplanationResponse.id) && Objects.equals(this.agent, adherenceExplanationResponse.agent) && Objects.equals(this.managementUnit, adherenceExplanationResponse.managementUnit) && Objects.equals(this.businessUnit, adherenceExplanationResponse.businessUnit) && Objects.equals((Object)this.type, (Object)adherenceExplanationResponse.type) && Objects.equals((Object)this.status, (Object)adherenceExplanationResponse.status) && Objects.equals(this.startDate, adherenceExplanationResponse.startDate) && Objects.equals(this.lengthMinutes, adherenceExplanationResponse.lengthMinutes) && Objects.equals(this.notes, adherenceExplanationResponse.notes) && Objects.equals(this.reviewedBy, adherenceExplanationResponse.reviewedBy) && Objects.equals(this.reviewedDate, adherenceExplanationResponse.reviewedDate) && Objects.equals(this.selfUri, adherenceExplanationResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.agent, this.managementUnit, this.businessUnit, this.type, this.status, this.startDate, this.lengthMinutes, this.notes, this.reviewedBy, this.reviewedDate, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdherenceExplanationResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    agent: ").append(this.toIndentedString(this.agent)).append("\n");
        sb.append("    managementUnit: ").append(this.toIndentedString(this.managementUnit)).append("\n");
        sb.append("    businessUnit: ").append(this.toIndentedString(this.businessUnit)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    lengthMinutes: ").append(this.toIndentedString(this.lengthMinutes)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    reviewedBy: ").append(this.toIndentedString(this.reviewedBy)).append("\n");
        sb.append("    reviewedDate: ").append(this.toIndentedString(this.reviewedDate)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        LATE("Late");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("Pending"),
        APPROVED("Approved"),
        DENIED("Denied");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

