/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.HistoricalAdherenceActuals;
import com.mypurecloud.sdk.v2.model.HistoricalAdherenceExceptionInfo;
import com.mypurecloud.sdk.v2.model.WfmHistoricalAdherenceBulkUserDayMetrics;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WfmHistoricalAdherenceBulkUserResult
implements Serializable {
    private String userId = null;
    private Double adherencePercentage = null;
    private Double conformancePercentage = null;
    private ImpactEnum impact = null;
    private List<HistoricalAdherenceExceptionInfo> exceptionInfo = null;
    private List<HistoricalAdherenceActuals> actuals = null;
    private List<WfmHistoricalAdherenceBulkUserDayMetrics> dayMetrics = null;

    public WfmHistoricalAdherenceBulkUserResult() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.exceptionInfo = new ArrayList<HistoricalAdherenceExceptionInfo>();
            this.actuals = new ArrayList<HistoricalAdherenceActuals>();
            this.dayMetrics = new ArrayList<WfmHistoricalAdherenceBulkUserDayMetrics>();
        }
    }

    public WfmHistoricalAdherenceBulkUserResult userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the user for whom the adherence is queried")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public WfmHistoricalAdherenceBulkUserResult adherencePercentage(Double adherencePercentage) {
        this.adherencePercentage = adherencePercentage;
        return this;
    }

    @ApiModelProperty(example="null", value="Adherence percentage for this user, in the scale of 0 - 100")
    @JsonProperty(value="adherencePercentage")
    public Double getAdherencePercentage() {
        return this.adherencePercentage;
    }

    public void setAdherencePercentage(Double adherencePercentage) {
        this.adherencePercentage = adherencePercentage;
    }

    public WfmHistoricalAdherenceBulkUserResult conformancePercentage(Double conformancePercentage) {
        this.conformancePercentage = conformancePercentage;
        return this;
    }

    @ApiModelProperty(example="null", value="Conformance percentage for this user, in the scale of 0 - 100. Conformance percentage can be greater than 100 when the actual on-queue time is greater than the scheduled on-queue time for the same period.")
    @JsonProperty(value="conformancePercentage")
    public Double getConformancePercentage() {
        return this.conformancePercentage;
    }

    public void setConformancePercentage(Double conformancePercentage) {
        this.conformancePercentage = conformancePercentage;
    }

    public WfmHistoricalAdherenceBulkUserResult impact(ImpactEnum impact) {
        this.impact = impact;
        return this;
    }

    @ApiModelProperty(example="null", value="The impact of the current adherence state for this user")
    @JsonProperty(value="impact")
    public ImpactEnum getImpact() {
        return this.impact;
    }

    public void setImpact(ImpactEnum impact) {
        this.impact = impact;
    }

    public WfmHistoricalAdherenceBulkUserResult exceptionInfo(List<HistoricalAdherenceExceptionInfo> exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="List of adherence exceptions for this user")
    @JsonProperty(value="exceptionInfo")
    public List<HistoricalAdherenceExceptionInfo> getExceptionInfo() {
        return this.exceptionInfo;
    }

    public void setExceptionInfo(List<HistoricalAdherenceExceptionInfo> exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    public WfmHistoricalAdherenceBulkUserResult actuals(List<HistoricalAdherenceActuals> actuals) {
        this.actuals = actuals;
        return this;
    }

    @ApiModelProperty(example="null", value="List of adherence actuals for this user")
    @JsonProperty(value="actuals")
    public List<HistoricalAdherenceActuals> getActuals() {
        return this.actuals;
    }

    public void setActuals(List<HistoricalAdherenceActuals> actuals) {
        this.actuals = actuals;
    }

    public WfmHistoricalAdherenceBulkUserResult dayMetrics(List<WfmHistoricalAdherenceBulkUserDayMetrics> dayMetrics) {
        this.dayMetrics = dayMetrics;
        return this;
    }

    @ApiModelProperty(example="null", value="Adherence and conformance metrics for days in query range")
    @JsonProperty(value="dayMetrics")
    public List<WfmHistoricalAdherenceBulkUserDayMetrics> getDayMetrics() {
        return this.dayMetrics;
    }

    public void setDayMetrics(List<WfmHistoricalAdherenceBulkUserDayMetrics> dayMetrics) {
        this.dayMetrics = dayMetrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WfmHistoricalAdherenceBulkUserResult wfmHistoricalAdherenceBulkUserResult = (WfmHistoricalAdherenceBulkUserResult)o;
        return Objects.equals(this.userId, wfmHistoricalAdherenceBulkUserResult.userId) && Objects.equals(this.adherencePercentage, wfmHistoricalAdherenceBulkUserResult.adherencePercentage) && Objects.equals(this.conformancePercentage, wfmHistoricalAdherenceBulkUserResult.conformancePercentage) && Objects.equals((Object)this.impact, (Object)wfmHistoricalAdherenceBulkUserResult.impact) && Objects.equals(this.exceptionInfo, wfmHistoricalAdherenceBulkUserResult.exceptionInfo) && Objects.equals(this.actuals, wfmHistoricalAdherenceBulkUserResult.actuals) && Objects.equals(this.dayMetrics, wfmHistoricalAdherenceBulkUserResult.dayMetrics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userId, this.adherencePercentage, this.conformancePercentage, this.impact, this.exceptionInfo, this.actuals, this.dayMetrics});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WfmHistoricalAdherenceBulkUserResult {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    adherencePercentage: ").append(this.toIndentedString(this.adherencePercentage)).append("\n");
        sb.append("    conformancePercentage: ").append(this.toIndentedString(this.conformancePercentage)).append("\n");
        sb.append("    impact: ").append(this.toIndentedString((Object)this.impact)).append("\n");
        sb.append("    exceptionInfo: ").append(this.toIndentedString(this.exceptionInfo)).append("\n");
        sb.append("    actuals: ").append(this.toIndentedString(this.actuals)).append("\n");
        sb.append("    dayMetrics: ").append(this.toIndentedString(this.dayMetrics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ImpactEnumDeserializer.class)
    public static enum ImpactEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        POSITIVE("Positive"),
        NEGATIVE("Negative"),
        NEUTRAL("Neutral"),
        UNKNOWN("Unknown");

        private String value;

        private ImpactEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ImpactEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ImpactEnum value : ImpactEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ImpactEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ImpactEnumDeserializer
    extends StdDeserializer<ImpactEnum> {
        public ImpactEnumDeserializer() {
            super(ImpactEnumDeserializer.class);
        }

        public ImpactEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ImpactEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

