/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class ShiftTradeActivityPreviewResponse
implements Serializable {
    private Date startDate = null;
    private Integer lengthMinutes = null;
    private String activityCodeId = null;
    private Boolean countsAsPaidTime = null;
    private Integer payableMinutes = null;
    private ExternalActivityTypeEnum externalActivityType = null;
    private String externalActivityId = null;

    public ShiftTradeActivityPreviewResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ShiftTradeActivityPreviewResponse startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The start date and time of this activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public ShiftTradeActivityPreviewResponse lengthMinutes(Integer lengthMinutes) {
        this.lengthMinutes = lengthMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The length in minutes of this activity")
    @JsonProperty(value="lengthMinutes")
    public Integer getLengthMinutes() {
        return this.lengthMinutes;
    }

    public void setLengthMinutes(Integer lengthMinutes) {
        this.lengthMinutes = lengthMinutes;
    }

    public ShiftTradeActivityPreviewResponse activityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the activity code for this activity")
    @JsonProperty(value="activityCodeId")
    public String getActivityCodeId() {
        return this.activityCodeId;
    }

    public void setActivityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
    }

    public ShiftTradeActivityPreviewResponse countsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this activity counts as paid time")
    @JsonProperty(value="countsAsPaidTime")
    public Boolean getCountsAsPaidTime() {
        return this.countsAsPaidTime;
    }

    public void setCountsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
    }

    public ShiftTradeActivityPreviewResponse payableMinutes(Integer payableMinutes) {
        this.payableMinutes = payableMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Payable minutes for this activity")
    @JsonProperty(value="payableMinutes")
    public Integer getPayableMinutes() {
        return this.payableMinutes;
    }

    public void setPayableMinutes(Integer payableMinutes) {
        this.payableMinutes = payableMinutes;
    }

    public ShiftTradeActivityPreviewResponse externalActivityType(ExternalActivityTypeEnum externalActivityType) {
        this.externalActivityType = externalActivityType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the external activity associated with this activity, if applicable")
    @JsonProperty(value="externalActivityType")
    public ExternalActivityTypeEnum getExternalActivityType() {
        return this.externalActivityType;
    }

    public void setExternalActivityType(ExternalActivityTypeEnum externalActivityType) {
        this.externalActivityType = externalActivityType;
    }

    public ShiftTradeActivityPreviewResponse externalActivityId(String externalActivityId) {
        this.externalActivityId = externalActivityId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the external activity associated with this activity, if applicable")
    @JsonProperty(value="externalActivityId")
    public String getExternalActivityId() {
        return this.externalActivityId;
    }

    public void setExternalActivityId(String externalActivityId) {
        this.externalActivityId = externalActivityId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftTradeActivityPreviewResponse shiftTradeActivityPreviewResponse = (ShiftTradeActivityPreviewResponse)o;
        return Objects.equals(this.startDate, shiftTradeActivityPreviewResponse.startDate) && Objects.equals(this.lengthMinutes, shiftTradeActivityPreviewResponse.lengthMinutes) && Objects.equals(this.activityCodeId, shiftTradeActivityPreviewResponse.activityCodeId) && Objects.equals(this.countsAsPaidTime, shiftTradeActivityPreviewResponse.countsAsPaidTime) && Objects.equals(this.payableMinutes, shiftTradeActivityPreviewResponse.payableMinutes) && Objects.equals((Object)this.externalActivityType, (Object)shiftTradeActivityPreviewResponse.externalActivityType) && Objects.equals(this.externalActivityId, shiftTradeActivityPreviewResponse.externalActivityId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startDate, this.lengthMinutes, this.activityCodeId, this.countsAsPaidTime, this.payableMinutes, this.externalActivityType, this.externalActivityId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShiftTradeActivityPreviewResponse {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    lengthMinutes: ").append(this.toIndentedString(this.lengthMinutes)).append("\n");
        sb.append("    activityCodeId: ").append(this.toIndentedString(this.activityCodeId)).append("\n");
        sb.append("    countsAsPaidTime: ").append(this.toIndentedString(this.countsAsPaidTime)).append("\n");
        sb.append("    payableMinutes: ").append(this.toIndentedString(this.payableMinutes)).append("\n");
        sb.append("    externalActivityType: ").append(this.toIndentedString((Object)this.externalActivityType)).append("\n");
        sb.append("    externalActivityId: ").append(this.toIndentedString(this.externalActivityId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ExternalActivityTypeEnumDeserializer.class)
    public static enum ExternalActivityTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVITYPLAN("ActivityPlan"),
        COACHING("Coaching"),
        LEARNING("Learning");

        private String value;

        private ExternalActivityTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ExternalActivityTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ExternalActivityTypeEnum value : ExternalActivityTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ExternalActivityTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ExternalActivityTypeEnumDeserializer
    extends StdDeserializer<ExternalActivityTypeEnum> {
        public ExternalActivityTypeEnumDeserializer() {
            super(ExternalActivityTypeEnumDeserializer.class);
        }

        public ExternalActivityTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ExternalActivityTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

