/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationReason;
import com.mypurecloud.sdk.v2.model.OpenMessagingChannel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Open Messaging rich media message structure")
public class OpenReceiptNormalizedMessage
implements Serializable {
    private String id = null;
    private OpenMessagingChannel channel = null;
    private TypeEnum type = null;
    private StatusEnum status = null;
    private List<ConversationReason> reasons = null;
    private Boolean isFinalReceipt = null;
    private DirectionEnum direction = null;

    public OpenReceiptNormalizedMessage() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.reasons = new ArrayList<ConversationReason>();
        }
    }

    public OpenReceiptNormalizedMessage id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The original unique message Id generated by the messaging platform, that this receipt message is referencing.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OpenReceiptNormalizedMessage channel(OpenMessagingChannel channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Channel-specific information that describes the message and the message channel/provider.")
    @JsonProperty(value="channel")
    public OpenMessagingChannel getChannel() {
        return this.channel;
    }

    public void setChannel(OpenMessagingChannel channel) {
        this.channel = channel;
    }

    public OpenReceiptNormalizedMessage type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Message type.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OpenReceiptNormalizedMessage status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Message receipt status.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OpenReceiptNormalizedMessage reasons(List<ConversationReason> reasons) {
        this.reasons = reasons;
        return this;
    }

    @ApiModelProperty(example="null", value="List of reasons for a message receipt that indicates the message has failed. Only used with Failed status.")
    @JsonProperty(value="reasons")
    public List<ConversationReason> getReasons() {
        return this.reasons;
    }

    public void setReasons(List<ConversationReason> reasons) {
        this.reasons = reasons;
    }

    public OpenReceiptNormalizedMessage isFinalReceipt(Boolean isFinalReceipt) {
        this.isFinalReceipt = isFinalReceipt;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if this is the last message receipt for this message, or if another message receipt can be expected.")
    @JsonProperty(value="isFinalReceipt")
    public Boolean getIsFinalReceipt() {
        return this.isFinalReceipt;
    }

    public void setIsFinalReceipt(Boolean isFinalReceipt) {
        this.isFinalReceipt = isFinalReceipt;
    }

    public OpenReceiptNormalizedMessage direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The direction of the message.")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenReceiptNormalizedMessage openReceiptNormalizedMessage = (OpenReceiptNormalizedMessage)o;
        return Objects.equals(this.id, openReceiptNormalizedMessage.id) && Objects.equals(this.channel, openReceiptNormalizedMessage.channel) && Objects.equals((Object)this.type, (Object)openReceiptNormalizedMessage.type) && Objects.equals((Object)this.status, (Object)openReceiptNormalizedMessage.status) && Objects.equals(this.reasons, openReceiptNormalizedMessage.reasons) && Objects.equals(this.isFinalReceipt, openReceiptNormalizedMessage.isFinalReceipt) && Objects.equals((Object)this.direction, (Object)openReceiptNormalizedMessage.direction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.channel, this.type, this.status, this.reasons, this.isFinalReceipt, this.direction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenReceiptNormalizedMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    reasons: ").append(this.toIndentedString(this.reasons)).append("\n");
        sb.append("    isFinalReceipt: ").append(this.toIndentedString(this.isFinalReceipt)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        RECEIPT("Receipt");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SENT("Sent"),
        DELIVERED("Delivered"),
        FAILED("Failed"),
        PUBLISHED("Published"),
        REMOVED("Removed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("Inbound"),
        OUTBOUND("Outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

