/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DecisionTableColumns;
import com.mypurecloud.sdk.v2.model.DecisionTableContract;
import com.mypurecloud.sdk.v2.model.Division;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class DecisionTableVersion
implements Serializable {
    private String id = null;
    private String name = null;
    private Division division = null;
    private Integer version = null;
    private StatusEnum status = null;
    private String description = null;
    private Integer rowCount = null;
    private String rowsUri = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Date datePublished = null;
    private DecisionTableColumns columns = null;
    private DecisionTableContract contract = null;
    private String selfUri = null;

    public DecisionTableVersion() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public DecisionTableVersion name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DecisionTableVersion division(Division division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division to which this entity belongs.")
    @JsonProperty(value="division")
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    public DecisionTableVersion version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="The decision table version.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public DecisionTableVersion status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="Current status of this decision table version")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public DecisionTableVersion description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The decision table description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DecisionTableVersion rowCount(Integer rowCount) {
        this.rowCount = rowCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of rows in this decision table version.")
    @JsonProperty(value="rowCount")
    public Integer getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(Integer rowCount) {
        this.rowCount = rowCount;
    }

    public DecisionTableVersion rowsUri(String rowsUri) {
        this.rowsUri = rowsUri;
        return this;
    }

    @ApiModelProperty(example="null", value="The rows URI for this decision table version.")
    @JsonProperty(value="rowsUri")
    public String getRowsUri() {
        return this.rowsUri;
    }

    public void setRowsUri(String rowsUri) {
        this.rowsUri = rowsUri;
    }

    @ApiModelProperty(example="null", value="UTC date time indicating when this decision table version was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="UTC date time indicating when this decision table version was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="UTC date time indicating when this decision table version was published. Null if never published. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="datePublished")
    public Date getDatePublished() {
        return this.datePublished;
    }

    public DecisionTableVersion columns(DecisionTableColumns columns) {
        this.columns = columns;
        return this;
    }

    @ApiModelProperty(example="null", value="The column definitions of this decision table version.")
    @JsonProperty(value="columns")
    public DecisionTableColumns getColumns() {
        return this.columns;
    }

    public void setColumns(DecisionTableColumns columns) {
        this.columns = columns;
    }

    public DecisionTableVersion contract(DecisionTableContract contract) {
        this.contract = contract;
        return this;
    }

    @ApiModelProperty(example="null", value="The contract information for this decision table version.")
    @JsonProperty(value="contract")
    public DecisionTableContract getContract() {
        return this.contract;
    }

    public void setContract(DecisionTableContract contract) {
        this.contract = contract;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionTableVersion decisionTableVersion = (DecisionTableVersion)o;
        return Objects.equals(this.id, decisionTableVersion.id) && Objects.equals(this.name, decisionTableVersion.name) && Objects.equals(this.division, decisionTableVersion.division) && Objects.equals(this.version, decisionTableVersion.version) && Objects.equals((Object)this.status, (Object)decisionTableVersion.status) && Objects.equals(this.description, decisionTableVersion.description) && Objects.equals(this.rowCount, decisionTableVersion.rowCount) && Objects.equals(this.rowsUri, decisionTableVersion.rowsUri) && Objects.equals(this.dateCreated, decisionTableVersion.dateCreated) && Objects.equals(this.dateModified, decisionTableVersion.dateModified) && Objects.equals(this.datePublished, decisionTableVersion.datePublished) && Objects.equals(this.columns, decisionTableVersion.columns) && Objects.equals(this.contract, decisionTableVersion.contract) && Objects.equals(this.selfUri, decisionTableVersion.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.division, this.version, this.status, this.description, this.rowCount, this.rowsUri, this.dateCreated, this.dateModified, this.datePublished, this.columns, this.contract, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecisionTableVersion {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    rowCount: ").append(this.toIndentedString(this.rowCount)).append("\n");
        sb.append("    rowsUri: ").append(this.toIndentedString(this.rowsUri)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    datePublished: ").append(this.toIndentedString(this.datePublished)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    contract: ").append(this.toIndentedString(this.contract)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DRAFT("Draft"),
        PUBLISHED("Published"),
        ERROR("Error"),
        PREPARING("Preparing"),
        SUPERSEDED("Superseded");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

